#include "devsetup.h"
#include <QDebug>
#include <QSettings>
#include <portaudio.h>

#define MAXDEVICES 100

extern double dFreq[16];
qint32  g2_iptt;
qint32  g2_COMportOpen;

//----------------------------------------------------------- DevSetup()
DevSetup::DevSetup(QWidget *parent) :	QDialog(parent)
{
  ui.setupUi(this);	                              //setup the dialog form
  m_restartSoundIn=false;
  m_restartSoundOut=false;
  m_firstCall=true;
  g2_iptt=0;
  m_test=0;
  m_bRigOpen=false;
  g2_COMportOpen=0;
}

DevSetup::~DevSetup()
{
}

void DevSetup::initDlg()
{
  QString m_appDir = QApplication::applicationDirPath();
  QString inifile = m_appDir + "/wsjtx.ini";
  QSettings settings(inifile, QSettings::IniFormat);
  settings.beginGroup("Common");
  QString catPortDriver = settings.value("CATdriver","None").toString();
  settings.endGroup();

  int k,id;
  int numDevices=Pa_GetDeviceCount();

  const PaDeviceInfo *pdi;
  int nchin;
  int nchout;
  char pa_device_name[128];
  char pa_device_hostapi[128];

  k=0;
  for(id=0; id<numDevices; id++ )  {
    pdi=Pa_GetDeviceInfo(id);
    nchin=pdi->maxInputChannels;
    if(nchin>0) {
      m_inDevList[k]=id;
      if (id == m_paInDevice)
        m_nDevIn = k;
      k++;
      sprintf((char*)(pa_device_name),"%s",pdi->name);
      sprintf((char*)(pa_device_hostapi),"%s",
              Pa_GetHostApiInfo(pdi->hostApi)->name);

#ifdef WIN32
      char *p,*p1;
      char p2[50];
      p1=(char*)"";
      p=strstr(pa_device_hostapi,"MME");
      if(p!=NULL) p1=(char*)"MME";
      p=strstr(pa_device_hostapi,"Direct");
      if(p!=NULL) p1=(char*)"DirectX";
      p=strstr(pa_device_hostapi,"WASAPI");
      if(p!=NULL) p1=(char*)"WASAPI";
      p=strstr(pa_device_hostapi,"ASIO");
      if(p!=NULL) p1=(char*)"ASIO";
      p=strstr(pa_device_hostapi,"WDM-KS");
      if(p!=NULL) p1=(char*)"WDM-KS";

      sprintf(p2,"%2d   %d   %-8s  %-39s",id,nchin,p1,pa_device_name);
      QString t(p2);
#else
      QString t;
      t.sprintf("%2d   %d   %-8s  %-39s",id,nchin,
                Pa_GetHostApiInfo(pdi->hostApi)->name,pdi->name);
#endif
      ui.comboBoxSndIn->addItem(t);
    }
  }

  k=0;
  for(id=0; id<numDevices; id++ )  {
    pdi=Pa_GetDeviceInfo(id);
    nchout=pdi->maxOutputChannels;
    if(nchout>0) {
      m_outDevList[k]=id;
      if (id == m_paOutDevice)
        m_nDevOut = k;
      k++;
      sprintf((char*)(pa_device_name),"%s",pdi->name);
      sprintf((char*)(pa_device_hostapi),"%s",
              Pa_GetHostApiInfo(pdi->hostApi)->name);

#ifdef WIN32
      char *p,*p1;
      char p2[50];
      p1=(char*)"";
      p=strstr(pa_device_hostapi,"MME");
      if(p!=NULL) p1=(char*)"MME";
      p=strstr(pa_device_hostapi,"Direct");
      if(p!=NULL) p1=(char*)"DirectX";
      p=strstr(pa_device_hostapi,"WASAPI");
      if(p!=NULL) p1=(char*)"WASAPI";
      p=strstr(pa_device_hostapi,"ASIO");
      if(p!=NULL) p1=(char*)"ASIO";
      p=strstr(pa_device_hostapi,"WDM-KS");
      if(p!=NULL) p1=(char*)"WDM-KS";
      sprintf(p2,"%2d   %d   %-8s  %-39s",id,nchout,p1,pa_device_name);
      QString t(p2);
#else
      QString t;
      t.sprintf("%2d   %d   %-8s  %-39s",id,nchout,
                Pa_GetHostApiInfo(pdi->hostApi)->name,pdi->name);
#endif
      ui.comboBoxSndOut->addItem(t);
    }
  }

  connect(&p4, SIGNAL(readyReadStandardOutput()),
                    this, SLOT(p4ReadFromStdout()));
  connect(&p4, SIGNAL(readyReadStandardError()),
          this, SLOT(p4ReadFromStderr()));
  connect(&p4, SIGNAL(error(QProcess::ProcessError)),
          this, SLOT(p4Error()));
  p4.start("rigctl -l");
  p4.waitForFinished(1000);
  ui.rigComboBox->addItem("  9998 Commander");
  ui.rigComboBox->addItem("  9999 Ham Radio Deluxe");

  QPalette pal(ui.myCallEntry->palette());
  if(m_myCall=="") {
    pal.setColor(QPalette::Base,"#ffccff");
  } else {
    pal.setColor(QPalette::Base,Qt::white);
  }
  ui.myCallEntry->setPalette(pal);
  ui.myGridEntry->setPalette(pal);
  ui.myCallEntry->setText(m_myCall);
  ui.myGridEntry->setText(m_myGrid);
  ui.pskReporterAntenna->setText(m_pskAntenna);

  ui.idIntSpinBox->setValue(m_idInt);
  ui.pttMethodComboBox->setCurrentIndex(m_pttMethodIndex);
  ui.saveDirEntry->setText(m_saveDir);
  ui.comboBoxSndIn->setCurrentIndex(m_nDevIn);
  ui.comboBoxSndOut->setCurrentIndex(m_nDevOut);
  ui.cbID73->setChecked(m_After73);
  ui.cbPSKReporter->setChecked(m_pskReporter);
  ui.cbSplit->setChecked(m_bSplit and m_catEnabled);
  ui.cbXIT->setChecked(m_bXIT);
  ui.cbXIT->setVisible(false);

  enableWidgets();

  ui.rigComboBox->setCurrentIndex(m_rigIndex);
  ui.catPortComboBox->setCurrentIndex(m_catPortIndex);
  ui.serialRateComboBox->setCurrentIndex(m_serialRateIndex);
  ui.dataBitsComboBox->setCurrentIndex(m_dataBitsIndex);
  ui.stopBitsComboBox->setCurrentIndex(m_stopBitsIndex);
  ui.handshakeComboBox->setCurrentIndex(m_handshakeIndex);
  ui.rbData->setChecked(m_pttData);
  ui.pollSpinBox->setValue(m_poll);

  // PY2SDR -- Per OS serial port names
  m_tmp=m_pttPort;
  ui.pttComboBox->clear();
  ui.catPortComboBox->clear();
  ui.pttComboBox->addItem("None");
  ui.catPortComboBox->addItem("None");
#ifdef WIN32
  for ( int i = 1; i < 100; i++ ) {
    ui.pttComboBox->addItem("COM" + QString::number(i));
    ui.catPortComboBox->addItem("COM" + QString::number(i));
  }
  ui.pttComboBox->addItem("USB");
  ui.catPortComboBox->addItem("USB");
#else
  ui.catPortComboBox->addItem("/dev/ttyS0");
  ui.catPortComboBox->addItem("/dev/ttyS1");
  ui.catPortComboBox->addItem("/dev/ttyS2");
  ui.catPortComboBox->addItem("/dev/ttyS3");
  ui.catPortComboBox->addItem("/dev/ttyS4");
  ui.catPortComboBox->addItem("/dev/ttyS5");
  ui.catPortComboBox->addItem("/dev/ttyS6");
  ui.catPortComboBox->addItem("/dev/ttyS7");
  ui.catPortComboBox->addItem("/dev/ttyUSB0");
  ui.catPortComboBox->addItem("/dev/ttyUSB1");
  ui.catPortComboBox->addItem("/dev/ttyUSB2");
  ui.catPortComboBox->addItem("/dev/ttyUSB3");
  ui.catPortComboBox->addItem(catPortDriver);

  ui.pttComboBox->addItem("/dev/ttyS0");
  ui.pttComboBox->addItem("/dev/ttyS1");
  ui.pttComboBox->addItem("/dev/ttyS2");
  ui.pttComboBox->addItem("/dev/ttyS3");
  ui.pttComboBox->addItem("/dev/ttyS4");
  ui.pttComboBox->addItem("/dev/ttyS5");
  ui.pttComboBox->addItem("/dev/ttyS6");
  ui.pttComboBox->addItem("/dev/ttyS7");
  ui.pttComboBox->addItem("/dev/ttyUSB0");
  ui.pttComboBox->addItem("/dev/ttyUSB1");
  ui.pttComboBox->addItem("/dev/ttyUSB2");
  ui.pttComboBox->addItem("/dev/ttyUSB3");
#endif
  ui.pttComboBox->setCurrentIndex(m_tmp);
  ui.catPortComboBox->setCurrentIndex(m_catPortIndex);

  int n=m_macro.length();
  if(n>=1) ui.macro1->setText(m_macro[0].toUpper());
  if(n>=2) ui.macro2->setText(m_macro[1].toUpper());
  if(n>=3) ui.macro3->setText(m_macro[2].toUpper());
  if(n>=4) ui.macro4->setText(m_macro[3].toUpper());
  if(n>=5) ui.macro5->setText(m_macro[4].toUpper());
  if(n>=6) ui.macro6->setText(m_macro[5].toUpper());
  if(n>=7) ui.macro7->setText(m_macro[6].toUpper());
  if(n>=8) ui.macro8->setText(m_macro[7].toUpper());
  if(n>=8) ui.macro9->setText(m_macro[8].toUpper());
  if(n>=10) ui.macro10->setText(m_macro[9].toUpper());

  ui.f1->setText(m_dFreq[0]);
  ui.f2->setText(m_dFreq[1]);
  ui.f3->setText(m_dFreq[2]);
  ui.f4->setText(m_dFreq[3]);
  ui.f5->setText(m_dFreq[4]);
  ui.f6->setText(m_dFreq[5]);
  ui.f7->setText(m_dFreq[6]);
  ui.f8->setText(m_dFreq[7]);
  ui.f9->setText(m_dFreq[8]);
  ui.f10->setText(m_dFreq[9]);
  ui.f11->setText(m_dFreq[10]);
  ui.f12->setText(m_dFreq[11]);
  ui.f13->setText(m_dFreq[12]);
  ui.f14->setText(m_dFreq[13]);
  ui.f15->setText(m_dFreq[14]);
  ui.f16->setText(m_dFreq[15]);
}

//------------------------------------------------------- accept()
void DevSetup::accept()
{
  // Called when OK button is clicked.
  // Check to see whether SoundInThread must be restarted,
  // and save user parameters.

  if(m_nDevIn!=ui.comboBoxSndIn->currentIndex() or
     m_paInDevice!=m_inDevList[m_nDevIn]) m_restartSoundIn=true;

  if(m_nDevOut!=ui.comboBoxSndOut->currentIndex() or
     m_paOutDevice!=m_outDevList[m_nDevOut]) m_restartSoundOut=true;

  m_myCall=ui.myCallEntry->text();
  m_myGrid=ui.myGridEntry->text();
  m_pskAntenna=ui.pskReporterAntenna->text();
  m_idInt=ui.idIntSpinBox->value();
  m_pttMethodIndex=ui.pttMethodComboBox->currentIndex();
  m_pttPort=ui.pttComboBox->currentIndex();
  m_saveDir=ui.saveDirEntry->text();
  m_nDevIn=ui.comboBoxSndIn->currentIndex();
  m_paInDevice=m_inDevList[m_nDevIn];
  m_nDevOut=ui.comboBoxSndOut->currentIndex();
  m_paOutDevice=m_outDevList[m_nDevOut];

  m_macro.clear();
  m_macro.append(ui.macro1->text());
  m_macro.append(ui.macro2->text());
  m_macro.append(ui.macro3->text());
  m_macro.append(ui.macro4->text());
  m_macro.append(ui.macro5->text());
  m_macro.append(ui.macro6->text());
  m_macro.append(ui.macro7->text());
  m_macro.append(ui.macro8->text());
  m_macro.append(ui.macro9->text());
  m_macro.append(ui.macro10->text());

  m_dFreq.clear();
  m_dFreq.append(ui.f1->text());
  m_dFreq.append(ui.f2->text());
  m_dFreq.append(ui.f3->text());
  m_dFreq.append(ui.f4->text());
  m_dFreq.append(ui.f5->text());
  m_dFreq.append(ui.f6->text());
  m_dFreq.append(ui.f7->text());
  m_dFreq.append(ui.f8->text());
  m_dFreq.append(ui.f9->text());
  m_dFreq.append(ui.f10->text());
  m_dFreq.append(ui.f11->text());
  m_dFreq.append(ui.f12->text());
  m_dFreq.append(ui.f13->text());
  m_dFreq.append(ui.f14->text());
  m_dFreq.append(ui.f15->text());
  m_dFreq.append(ui.f16->text());

  if(m_bRigOpen) {
    rig->close();
    if(m_rig<9900) delete rig;
    m_bRigOpen=false;
  }

  QDialog::accept();
}

//------------------------------------------------------- reject()
void DevSetup::reject()
{
  if(m_bRigOpen) rig->close();
  QDialog::reject();
}

void DevSetup::p4ReadFromStdout()                        //p4readFromStdout
{
  while(p4.canReadLine()) {
    QString t(p4.readLine());
    QString t1,t2,t3;
    if(t.mid(0,6)!=" Rig #") {
      t1=t.mid(0,6);
      t2=t.mid(8,22).trimmed();
      t3=t.mid(31,23).trimmed();
      t=t1 + "  " + t2 + "  " + t3;
      ui.rigComboBox->addItem(t);
    }
  }
}

void DevSetup::p4ReadFromStderr()                        //p4readFromStderr
{
  QByteArray t=p4.readAllStandardError();
  if(t.length()>0) {
    msgBox(t);
  }
}

void DevSetup::p4Error()                                     //p4rror
{
  msgBox("Error running 'rigctl -l'.");
}

void DevSetup::msgBox(QString t)                             //msgBox
{
  msgBox0.setText(t);
  msgBox0.exec();
}

void DevSetup::on_myCallEntry_editingFinished()
{
  QString t=ui.myCallEntry->text();
  ui.myCallEntry->setText(t.toUpper());
}

void DevSetup::on_myGridEntry_editingFinished()
{
  QString t=ui.myGridEntry->text();
  t=t.mid(0,4).toUpper()+t.mid(4,2).toLower();
  ui.myGridEntry->setText(t);
}

void DevSetup::on_cbPSKReporter_clicked(bool b)
{
  m_pskReporter=b;
  ui.label_8->setEnabled(m_pskReporter);
  ui.pskReporterAntenna->setEnabled(m_pskReporter);
}

void DevSetup::on_pttMethodComboBox_activated(int index)
{
  m_pttMethodIndex=index;
  enableWidgets();
}

void DevSetup::on_catPortComboBox_activated(int index)
{
  m_catPortIndex=index;
  m_catPort=ui.catPortComboBox->itemText(index);
}

void DevSetup::on_cbEnableCAT_toggled(bool b)
{
  m_catEnabled=b;
  enableWidgets();
  ui.cbSplit->setChecked(m_bSplit and m_catEnabled);
}

void DevSetup::on_serialRateComboBox_activated(int index)
{
  m_serialRateIndex=index;
  m_serialRate=ui.serialRateComboBox->itemText(index).toInt();
}

void DevSetup::on_handshakeComboBox_activated(int index)
{
  m_handshakeIndex=index;
  m_handshake=ui.handshakeComboBox->itemText(index);
}

void DevSetup::on_dataBitsComboBox_activated(int index)
{
  m_dataBitsIndex=index;
  m_dataBits=ui.dataBitsComboBox->itemText(index).toInt();
}

void DevSetup::on_stopBitsComboBox_activated(int index)
{
  m_stopBitsIndex=index;
  m_stopBits=ui.stopBitsComboBox->itemText(index).toInt();
}

void DevSetup::on_rigComboBox_activated(int index)
{
  m_rigIndex=index;
  QString t=ui.rigComboBox->itemText(index);
  m_rig=t.mid(0,7).toInt();
  enableWidgets();
}

void DevSetup::on_cbID73_toggled(bool checked)
{
  m_After73=checked;
}

void DevSetup::on_testCATButton_clicked()
{
  openRig();
  if(!m_catEnabled) return;
  QString t;
  double fMHz=rig->getFreq(RIG_VFO_CURR)/1000000.0;
  if(fMHz>0.0) {
    t.sprintf("Rig control appears to be working.\nDial Frequency:  %.6f MHz",
              fMHz);
  } else {
    t.sprintf("Rig control error %d\nFailed to read frequency.",
              int(1000000.0*fMHz));
    if(m_poll>0) {
      m_catEnabled=false;
      ui.cbEnableCAT->setChecked(false);
    }
  }
  msgBox(t);
}

void DevSetup::openRig()
{
  QString t;
  int ret;

  if(!m_catEnabled) return;
  if(m_bRigOpen) {
    rig->close();
    if(m_rig<9900) delete rig;
    m_bRigOpen=false;
  }

  rig = new Rig();

  if(m_rig<9900) {
    if (!rig->init(m_rig)) {
      msgBox("Rig init failure");
      m_catEnabled=false;
      return;
    }
    QString sCATport=m_catPort;
#ifdef WIN32
    sCATport="\\\\.\\" + m_catPort;    //Allow COM ports above 9
#endif
    rig->setConf("rig_pathname", sCATport.toLatin1().data());
    char buf[80];
    sprintf(buf,"%d",m_serialRate);
    rig->setConf("serial_speed",buf);
    sprintf(buf,"%d",m_dataBits);
    rig->setConf("data_bits",buf);
    sprintf(buf,"%d",m_stopBits);
    rig->setConf("stop_bits",buf);
    rig->setConf("serial_handshake",m_handshake.toLatin1().data());
    if(m_bDTRoff) {
      rig->setConf("rts_state","OFF");
      rig->setConf("dtr_state","OFF");
    }
  }

  ret=rig->open(m_rig);
  if(ret==RIG_OK) {
    m_bRigOpen=true;
  } else {
    t="Open rig failed";
    msgBox(t);
    m_catEnabled=false;
    ui.cbEnableCAT->setChecked(false);
    return;
  }
}

void DevSetup::on_testPTTButton_clicked()
{
  m_test=1-m_test;
  if(m_pttMethodIndex==1 or m_pttMethodIndex==2) {
    ptt(m_pttPort,m_test,&g2_iptt,&g2_COMportOpen);
  }
  if(m_pttMethodIndex==0 and !m_bRigOpen) {
//    on_testCATButton_clicked();
    openRig();
  }
  if(m_pttMethodIndex==0 and m_bRigOpen) {
    if(m_test==0) rig->setPTT(RIG_PTT_OFF, RIG_VFO_CURR);
    if(m_test==1) {
      if(m_pttData) rig->setPTT(RIG_PTT_ON_DATA, RIG_VFO_CURR);
      if(!m_pttData) rig->setPTT(RIG_PTT_ON_MIC, RIG_VFO_CURR);
    }
  }
}

void DevSetup::on_cbDTRoff_toggled(bool checked)
{
  m_bDTRoff=checked;
}

void DevSetup::on_rbData_toggled(bool checked)
{
  m_pttData=checked;
}

void DevSetup::on_pollSpinBox_valueChanged(int n)
{
  m_poll=n;
}

void DevSetup::on_pttComboBox_currentIndexChanged(int index)
{
  m_pttPort=index;
  enableWidgets();
}

void DevSetup::on_pttMethodComboBox_currentIndexChanged(int index)
{
  m_pttMethodIndex=index;
  bool b=m_pttMethodIndex==1 or m_pttMethodIndex==2;
  ui.pttComboBox->setEnabled(b);
}

void DevSetup::enableWidgets()
{
  ui.label_8->setEnabled(m_pskReporter);
  ui.pskReporterAntenna->setEnabled(m_pskReporter);

  ui.cbEnableCAT->setChecked(m_catEnabled);
  ui.cbDTRoff->setChecked(m_bDTRoff);
  ui.rigComboBox->setEnabled(m_catEnabled);
  ui.testCATButton->setEnabled(m_catEnabled);
  ui.label_4->setEnabled(m_catEnabled);
  ui.label_47->setEnabled(m_catEnabled);
  ui.cbSplit->setEnabled(m_catEnabled);
  if(m_rig==9999) {                    //No Split Tx with HRD
    ui.cbSplit->setChecked(false);
    ui.cbSplit->setEnabled(false);
  }
  ui.cbXIT->setEnabled(m_catEnabled);

  bool bSerial=m_catEnabled and (m_rig<9900);
  ui.catPortComboBox->setEnabled(bSerial);
  ui.serialRateComboBox->setEnabled(bSerial);
  ui.dataBitsComboBox->setEnabled(bSerial);
  ui.stopBitsComboBox->setEnabled(bSerial);
  ui.handshakeComboBox->setEnabled(bSerial);
  ui.cbDTRoff->setEnabled(bSerial);
  ui.rbData->setEnabled(bSerial);
  ui.rbMic->setEnabled(bSerial);
  ui.label_21->setEnabled(bSerial);
  ui.label_22->setEnabled(bSerial);
  ui.label_23->setEnabled(bSerial);
  ui.label_24->setEnabled(bSerial);
  ui.label_25->setEnabled(bSerial);

  ui.pollSpinBox->setEnabled(m_catEnabled);
  bool b1=(m_pttMethodIndex==1 or m_pttMethodIndex==2);
  ui.pttComboBox->setEnabled(b1);
  b1=b1 and (m_pttPort!=0);
  bool b2 = (m_catEnabled and m_pttMethodIndex==1 and m_rig<9900) or
            (m_catEnabled and m_pttMethodIndex==2 and m_rig<9900);
  bool b3 = (m_catEnabled and m_pttMethodIndex==0);
  ui.testPTTButton->setEnabled(b1 or b2 or b3);  //Include PTT via HRD or Commander
}

void DevSetup::on_cbSplit_toggled(bool checked)
{
  m_bSplit=checked;
  if(m_bSplit and m_bXIT) ui.cbXIT->setChecked(false);
}

void DevSetup::on_cbXIT_toggled(bool checked)
{
  m_bXIT=checked;
  if(m_bSplit and m_bXIT) ui.cbSplit->setChecked(false);
}
