# -*- coding: utf-8 -*-
"""
web2ldap plugin classes for sudo-ldap
(see http://www.sudo.ws/sudoers.ldap.man.html)
"""


from w2lapp.schema.syntaxes import DynamicValueSelectList,syntax_registry


class SudoUserGroup(DynamicValueSelectList):
  oid = 'SudoUserGroup-oid'
  desc = 'United Internet: sudoUser'
  ldap_url = 'ldap:///_?cn,cn?sub?(objectClass=posixGroup)'
  valuePrefix = '%'


# Register all syntax classes in this module
for symbol_name in dir():
  syntax_registry.registerSyntaxClass(eval(symbol_name))
