/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class VRMLParserUtils {
    private VRMLParserUtils() {
    }

    public static String[] parseFileHeader(InputStream inputStream) throws IOException {
        char[] cArray = new char[2];
        String[] stringArray = null;
        cArray[0] = (char)inputStream.read();
        cArray[1] = (char)inputStream.read();
        if (cArray[0] != '#' || cArray[1] != 'V' && cArray[1] != 'X') {
            stringArray = new String[]{new String(cArray)};
        } else {
            char c;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(cArray);
            while ((c = (char)inputStream.read()) != '\n' && c != '\r' && c != '\uffffffff') {
                stringBuffer.append(c);
            }
            stringArray = VRMLParserUtils.parseHeaderString(stringBuffer.toString());
        }
        return stringArray;
    }

    public static String[] parseFileHeader(Reader reader) throws IOException {
        char[] cArray = new char[2];
        String[] stringArray = null;
        cArray[0] = (char)reader.read();
        cArray[1] = (char)reader.read();
        if (cArray[0] != '#' || cArray[1] != 'V' && cArray[1] != 'X') {
            stringArray = new String[]{new String(cArray)};
        } else {
            char c;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(cArray);
            while ((c = (char)reader.read()) != '\n' && c != '\r' && c != '\uffffffff') {
                stringBuffer.append(c);
            }
            stringArray = VRMLParserUtils.parseHeaderString(stringBuffer.toString());
        }
        return stringArray;
    }

    private static String[] parseHeaderString(String string) throws IOException {
        String[] stringArray = new String[]{null, null, null, null};
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        try {
            stringArray[0] = stringTokenizer.nextToken();
            stringArray[1] = stringTokenizer.nextToken();
            stringArray[2] = stringTokenizer.nextToken();
            stringArray[3] = stringTokenizer.nextToken("");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return stringArray;
    }
}

