/*
 * Decompiled with CFR 0.152.
 */
package spec.jbb;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import spec.jbb.JBButil;

public class JBBProperties {
    static final String COPYRIGHT = "SPECjbb2005,Copyright (c) 2005 Standard Performance Evaluation Corporation (SPEC),All rights reserved,(C) Copyright IBM Corp., 1996 - 2005All rights reserved,Licensed Materials - Property of SPEC";
    private Properties PropertiesForBatch;
    String val;
    public int warehousePopulationBase;
    public int orderlinesPerOrder;
    public int rampupSeconds;
    public int measurementSeconds;
    public int expectedPeakWarehouse = 4;
    public boolean deterministicRandomSeed = false;
    public int jvm_instances = 1;
    public float per_jvm_warehouse_rampup = 0.0f;
    public float per_jvm_warehouse_rampdown = 0.0f;
    public int waitTimePercent;
    public boolean showWarehouseDetail = false;
    public int startingNumberWarehouses;
    public int incrementNumberWarehouses;
    public int endingNumberWarehouses;
    public int[] sequenceOfWarehouses;
    public boolean steadyStateFlag;
    public boolean screenWriteFlag;
    public boolean checkThroughput;
    public float minBTPSRatio;
    public static int overrideItemTableSize = 20000;
    public static boolean uniformRandomItems = true;
    public static boolean printPropertiesAndArgs = true;
    private Level applicationLoggingLevel = Level.ALL;
    private static final float COMPLIANT_RATE_per_jvm_warehouse_rampup = 3.0f;
    private static final float COMPLIANT_RATE_per_jvm_warehouse_rampdown = 20.0f;
    private static final int COMPLIANT_RATE_warehousePopulationBase = 60;
    private static final int COMPLIANT_RATE_orderlinesPerOrder = 10;
    private static final int COMPLIANT_RATE_rampupSeconds = 30;
    private static final int COMPLIANT_RATE_measurementSeconds = 240;
    private static final int COMPLIANT_RATE_waitTimePercent = 0;
    private static final boolean COMPLIANT_RATE_steadyStateFlag = true;
    private static final boolean COMPLIANT_RATE_screenWriteFlag = false;
    private static final boolean COMPLIANT_RATE_uniformRandomItems = true;
    private static final int COMPLIANT_RATE_overrideItemTableSize = 20000;
    private static final boolean COMPLIANT_RATE_deterministicRandomSeed = false;
    private static final Level COMPLIANT_RATE_applicationLoggingLevel = Level.INFO;

    public JBBProperties(String string) {
        FileInputStream fileInputStream;
        System.out.println("");
        System.out.println("Loading properties from " + string);
        try {
            fileInputStream = new FileInputStream(string);
            this.PropertiesForBatch = new Properties();
            this.PropertiesForBatch.load(fileInputStream);
        }
        catch (IOException iOException) {
            JBButil.getLog().log(Level.WARNING, "ERROR:  Properties File error; please start again", iOException);
            return;
        }
        this.val = this.getOptionalProperty("input.include_file");
        if (this.val != null) {
            try {
                fileInputStream = new FileInputStream(this.val);
                this.PropertiesForBatch.load(fileInputStream);
            }
            catch (IOException iOException) {
                JBButil.getLog().log(Level.WARNING, "ERROR:  Properties File error with included properties file; please start again", iOException);
                return;
            }
        }
    }

    public String getRequiredProperty(String string) {
        try {
            return this.PropertiesForBatch.getProperty(string).trim();
        }
        catch (NullPointerException nullPointerException) {
            JBButil.getLog().log(Level.WARNING, "ERROR:  Property " + string + " not specified; please add to Properties File", nullPointerException);
            return null;
        }
    }

    public void setRequiredProperty(String string, String string2) {
        try {
            this.PropertiesForBatch.put(string, string2);
        }
        catch (NullPointerException nullPointerException) {
            JBButil.getLog().log(Level.WARNING, "ERROR: setting " + string, nullPointerException);
        }
    }

    public String getOptionalProperty(String string) {
        try {
            return this.PropertiesForBatch.getProperty(string).trim();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public boolean getProps() {
        String string = "input.";
        int n = 0;
        boolean bl = true;
        boolean bl2 = false;
        this.sequenceOfWarehouses = null;
        String string2 = this.getRequiredProperty(string + "suite");
        if (string2 != null) {
            if (string2.equals("SPECjbb")) {
                this.checkThroughput = false;
            } else {
                System.out.println("ERROR:  Property file error");
                System.out.println("   suite must be SPECjbb");
                bl = false;
            }
        } else {
            bl = false;
        }
        string2 = this.getRequiredProperty(string + "log_level");
        if (string2 != null) {
            try {
                this.applicationLoggingLevel = Level.parse(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                bl = false;
            }
        } else {
            bl = false;
        }
        if (this.checkThroughput) {
            string2 = this.getRequiredProperty(string + "min_capacity_ratio");
            if (string2 != null) {
                this.minBTPSRatio = Float.valueOf(string2).floatValue();
            } else {
                bl = false;
            }
        }
        if ((string2 = this.getOptionalProperty(string + "warehouse_population")) != null) {
            this.warehousePopulationBase = Integer.parseInt(string2);
        } else {
            this.warehousePopulationBase = 60;
            this.PropertiesForBatch.put(string + "warehouse_population", "60");
        }
        string2 = this.getOptionalProperty(string + "orderlines_per_order");
        if (string2 != null) {
            this.orderlinesPerOrder = Integer.parseInt(string2);
        } else {
            this.orderlinesPerOrder = 10;
            this.PropertiesForBatch.put(string + "orderlines_per_order", "10");
        }
        string2 = this.getRequiredProperty(string + "ramp_up_seconds");
        if (string2 != null) {
            this.rampupSeconds = Integer.parseInt(string2);
        } else {
            bl = false;
        }
        string2 = this.getRequiredProperty(string + "jvm_instances");
        if (string2 != null) {
            this.jvm_instances = Integer.parseInt(string2);
        } else {
            bl = false;
        }
        string2 = this.getRequiredProperty(string + "per_jvm_warehouse_rampup");
        if (string2 != null) {
            this.per_jvm_warehouse_rampup = Float.parseFloat(string2);
        } else {
            bl = false;
        }
        string2 = this.getRequiredProperty(string + "per_jvm_warehouse_rampdown");
        if (string2 != null) {
            this.per_jvm_warehouse_rampdown = Float.parseFloat(string2);
        } else {
            bl = false;
        }
        string2 = this.getRequiredProperty(string + "measurement_seconds");
        if (string2 != null) {
            this.measurementSeconds = Integer.parseInt(string2);
        } else {
            bl = false;
        }
        string2 = this.getOptionalProperty(string + "expected_peak_warehouse");
        if (string2 != null) {
            n = Integer.parseInt(string2);
            if (n == 0) {
                n = Runtime.getRuntime().availableProcessors();
                this.expectedPeakWarehouse = this.jvm_instances > 1 && n > 1 ? Runtime.getRuntime().availableProcessors() / this.jvm_instances : Runtime.getRuntime().availableProcessors();
            } else {
                if (n == Runtime.getRuntime().availableProcessors()) {
                    System.out.println("Warning: Explicitly setting " + string + "expected_peak_warehouse");
                    System.out.println("requires submission and review by SPEC in order to publish the result.");
                }
                this.expectedPeakWarehouse = n;
            }
        } else {
            n = Runtime.getRuntime().availableProcessors();
            this.expectedPeakWarehouse = this.jvm_instances > 1 && n > 1 ? Runtime.getRuntime().availableProcessors() / this.jvm_instances : Runtime.getRuntime().availableProcessors();
        }
        this.PropertiesForBatch.put(string + "expected_peak_warehouse", String.valueOf(this.expectedPeakWarehouse));
        string2 = this.getRequiredProperty(string + "deterministic_random_seed");
        if (string2 != null) {
            this.deterministicRandomSeed = Boolean.parseBoolean(string2);
        } else {
            bl = false;
        }
        string2 = this.getOptionalProperty(string + "wait_time_percent");
        if (string2 != null) {
            this.waitTimePercent = Integer.parseInt(string2);
        } else {
            this.waitTimePercent = 0;
            this.PropertiesForBatch.put(string + "wait_time_percent", "0");
        }
        string2 = this.getOptionalProperty(string + "screen_write");
        if (string2 != null) {
            if (string2.equals("true")) {
                this.screenWriteFlag = true;
            } else if (string2.equals("false")) {
                this.screenWriteFlag = false;
            } else {
                System.out.println("ERROR:  Property file error");
                System.out.println("   screen_write must be 'true' or 'false'");
                bl = false;
            }
        } else {
            this.screenWriteFlag = false;
            this.PropertiesForBatch.put(string + "screen_write", "false");
        }
        string2 = this.getOptionalProperty(string + "steady_state");
        if (string2 != null) {
            if (string2.equals("true")) {
                this.steadyStateFlag = true;
            } else if (string2.equals("false")) {
                this.steadyStateFlag = false;
            } else {
                System.out.println("ERROR:  Property file error");
                System.out.println("   steady_state must be 'true' or 'false'");
                bl = false;
            }
        } else {
            this.steadyStateFlag = true;
            this.PropertiesForBatch.put(string + "steady_state", "true");
        }
        string2 = this.getOptionalProperty(string + "override_itemtable_size");
        if (string2 != null) {
            overrideItemTableSize = Integer.parseInt(string2);
        }
        if ((string2 = this.getOptionalProperty(string + "uniform_random_items")) != null) {
            if (string2.equals("true")) {
                uniformRandomItems = true;
            } else if (string2.equals("false")) {
                uniformRandomItems = false;
            } else {
                System.out.println("ERROR:  Property file error");
                System.out.println("   uniform_random_items must be true or false");
                bl = false;
            }
        }
        if ((string2 = this.getOptionalProperty(string + "starting_number_warehouses")) != null) {
            this.startingNumberWarehouses = Integer.parseInt(string2);
        }
        if ((string2 = this.getOptionalProperty(string + "increment_number_warehouses")) != null) {
            this.incrementNumberWarehouses = Integer.parseInt(string2);
        }
        if ((string2 = this.getOptionalProperty(string + "ending_number_warehouses")) != null) {
            this.endingNumberWarehouses = Integer.parseInt(string2);
        } else {
            this.endingNumberWarehouses = this.expectedPeakWarehouse * 2;
            if (this.endingNumberWarehouses < 8) {
                this.endingNumberWarehouses = 8;
            }
            this.PropertiesForBatch.put(string + "ending_number_warehouses", String.valueOf(this.endingNumberWarehouses));
        }
        if (this.startingNumberWarehouses > 0 && this.endingNumberWarehouses >= this.startingNumberWarehouses && this.incrementNumberWarehouses > 0) {
            bl2 = true;
        }
        if ((string2 = this.getOptionalProperty(string + "sequence_of_number_of_warehouses")) != null) {
            if (bl2) {
                System.out.println("ERROR:  Property file error");
                System.out.println("   Cannot specify both sequence_of_number_of_warehouses and {starting,ending,increment}_number_warehouses");
                bl = false;
            } else {
                int n2;
                int n3 = 0;
                int n4 = 0;
                while ((n2 = string2.indexOf(32, n3)) > 0) {
                    ++n4;
                    n3 = n2 + 1;
                }
                this.sequenceOfWarehouses = new int[++n4];
                n3 = 0;
                n4 = 0;
                while ((n2 = string2.indexOf(32, n3)) > 0) {
                    this.sequenceOfWarehouses[n4] = Integer.parseInt(string2.substring(n3, n2));
                    ++n4;
                    n3 = n2 + 1;
                }
                this.sequenceOfWarehouses[n4] = Integer.parseInt(string2.substring(n3, string2.length()));
                ++n4;
                bl2 = true;
                for (int i = 1; i < n4; ++i) {
                    if (this.sequenceOfWarehouses[i] >= this.sequenceOfWarehouses[i - 1]) continue;
                    bl2 = false;
                    break;
                }
            }
        }
        if ((string2 = this.getOptionalProperty(string + "print_properties_and_args")) != null) {
            if (string2.equals("true")) {
                printPropertiesAndArgs = true;
            } else if (string2.equals("false")) {
                printPropertiesAndArgs = false;
            } else {
                System.out.println("ERROR:  Property file error");
                System.out.println("   print_properties_and_args must be true or false");
                bl = false;
            }
        }
        System.out.println("\nInput Properties:");
        System.out.println("  per_jvm_warehouse_rampup = " + this.per_jvm_warehouse_rampup);
        System.out.println("  per_jvm_warehouse_rampdown = " + this.per_jvm_warehouse_rampdown);
        System.out.println("  jvm_instances = " + this.jvm_instances);
        System.out.println("  deterministic_random_seed = " + this.deterministicRandomSeed);
        System.out.println("  ramp_up_seconds = " + this.rampupSeconds);
        System.out.println("  measurement_seconds = " + this.measurementSeconds);
        if (this.checkThroughput) {
            // empty if block
        }
        if (this.sequenceOfWarehouses == null) {
            System.out.println("  starting_number_warehouses = " + this.startingNumberWarehouses);
            System.out.println("  increment_number_warehouses = " + this.incrementNumberWarehouses);
            System.out.println("  ending_number_warehouses = " + this.endingNumberWarehouses);
            System.out.println("  expected_peak_warehouse = " + this.expectedPeakWarehouse);
        } else {
            System.out.print("  sequence_of_number_of_warehouses = ");
            for (int i = 0; i < this.sequenceOfWarehouses.length; ++i) {
                System.out.print(" " + this.sequenceOfWarehouses[i]);
            }
            System.out.println("  expected_peak_warehouse = " + this.expectedPeakWarehouse);
            System.out.println("");
        }
        if (!bl2) {
            System.out.println("ERROR:  Property file error");
            System.out.println("   No valid warehouse sequence specified.");
        }
        if (overrideItemTableSize > 0) {
            // empty if block
        }
        return bl && bl2;
    }

    public boolean copyPropsToOutput(PrintStream printStream) {
        boolean bl = true;
        String[] stringArray = new String[]{"suite", "log_level", "warehouse_population", "orderlines_per_order", "ramp_up_seconds", "measurement_seconds", "wait_time_percent", "screen_write", "steady_state", "starting_number_warehouses", "increment_number_warehouses", "ending_number_warehouses", "sequence_of_number_of_warehouses", "include_file", "override_itemtable_size", "uniform_random_items", "print_properties_and_args", "output_directory", "expected_peak_warehouse", "deterministic_random_seed", "jvm_instances", "per_jvm_warehouse_rampup", "per_jvm_warehouse_rampdown"};
        int n = 0;
        Object object = this.PropertiesForBatch.propertyNames();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            if (string.startsWith("config.")) {
                ++n;
                continue;
            }
            if (string.startsWith("input.")) {
                boolean bl2 = false;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!string.equals("input." + stringArray[i])) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) {
                    ++n;
                    continue;
                }
                if (string.equals("input.min_capacity_ratio")) {
                    if (this.checkThroughput) {
                        ++n;
                        continue;
                    }
                    System.out.println("ERROR:  Property file error");
                    System.out.println("   input.min_capacity_ratio invalid for input.suite=SPECjbb");
                    bl = false;
                    continue;
                }
                if (string.equals("input.show_warehouse_detail")) {
                    if (this.PropertiesForBatch.getProperty("input.show_warehouse_detail").equalsIgnoreCase("true")) {
                        this.showWarehouseDetail = true;
                    }
                    ++n;
                    continue;
                }
                System.out.println("ERROR:  Property file error");
                System.out.println("   Unrecognized property:  " + string);
                bl = false;
                continue;
            }
            System.out.println("ERROR:  Property file error");
            System.out.println("   Unrecognized property:  " + string);
            bl = false;
        }
        if (bl) {
            object = new Vector<Object>(this.PropertiesForBatch.keySet());
            Collections.sort(object);
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                String string = (String)((Vector)object).elementAt(i);
                String string2 = this.PropertiesForBatch.getProperty(string);
                printStream.println(string + "=" + string2);
            }
            Integer n2 = new Integer(Runtime.getRuntime().availableProcessors());
            printStream.println("config.sw.procsAvailtoJava=" + n2.toString());
        }
        return bl;
    }

    public String setProp(String string, String string2) {
        this.PropertiesForBatch.put(string, string2);
        return this.PropertiesForBatch.getProperty(string);
    }

    private boolean checkCompliance(int n, int n2, String string) {
        if (n != n2) {
            System.out.println("INVALID:  " + string + " = " + n + ", must be " + n2);
            return false;
        }
        return true;
    }

    private boolean checkCompliance(boolean bl, boolean bl2, String string) {
        if (bl != bl2) {
            System.out.println("INVALID:  " + string + " = " + bl + ", must be " + bl2);
            return false;
        }
        return true;
    }

    private boolean checkCompliance(float f, float f2, String string) {
        if (f != f2) {
            System.out.println("INVALID:  " + string + " = " + f + ", must be " + f2);
            return false;
        }
        return true;
    }

    private boolean checkCompliance(Level level, Level level2, String string) {
        if (!level.equals(level2)) {
            System.out.println("INVALID:  " + string + " = " + level + ", must be " + level2);
            return false;
        }
        return true;
    }

    public void checkCompliance() {
        boolean bl = true;
        System.out.println("\n\nChecking whether run will be valid");
        if (!this.checkThroughput) {
            bl = this.checkCompliance(this.warehousePopulationBase, 60, "warehouse_population_base") && bl;
            bl = this.checkCompliance(this.orderlinesPerOrder, 10, "orderlines_per_order") && bl;
            bl = this.checkCompliance(this.deterministicRandomSeed, false, "deterministic_random_seed") && bl;
            bl = this.checkCompliance(this.per_jvm_warehouse_rampup, 3.0f, "per_jvm_warehouse_rampup") && bl;
            bl = this.checkCompliance(this.per_jvm_warehouse_rampdown, 20.0f, "per_jvm_warehouse_rampdown") && bl;
            bl = this.checkCompliance(this.rampupSeconds, 30, "ramp_up_seconds") && bl;
            bl = this.checkCompliance(this.measurementSeconds, 240, "measurement_seconds") && bl;
            bl = this.checkCompliance(this.waitTimePercent, 0, "wait_time_percent") && bl;
            bl = this.checkCompliance(this.steadyStateFlag, true, "steady_state") && bl;
            bl = this.checkCompliance(this.screenWriteFlag, false, "screen_write") && bl;
            bl = this.checkCompliance(uniformRandomItems, true, "uniform_random_items") && bl;
            boolean bl2 = bl = this.checkCompliance(this.applicationLoggingLevel, COMPLIANT_RATE_applicationLoggingLevel, "log_level") && bl;
            if (overrideItemTableSize > 0) {
                boolean bl3 = bl = this.checkCompliance(overrideItemTableSize, 20000, "override_itemtable_size") && bl;
            }
        }
        if (bl) {
            System.out.println();
            System.out.println("Run will be COMPLIANT");
            System.out.println();
        } else {
            System.out.println();
            System.out.println("INVALID:  Run will NOT be compliant");
            System.out.println();
        }
    }

    public Level getApplicationLoggingLevel() {
        return this.applicationLoggingLevel;
    }
}

