/*-----------------------------------------------------------------------

                         SYRTHES version 3.4
                         -------------------

     This file is part of the SYRTHES Kernel, element of the
     thermal code SYRTHES.

     Copyright (C) 1988-2008 EDF S.A., France

     contact: syrthes-support@edf.fr


     The SYRTHES Kernel is free software; you can redistribute it
     and/or modify it under the terms of the GNU General Public License
     as published by the Free Software Foundation; either version 2 of
     the License, or (at your option) any later version.

     The SYRTHES Kernel is distributed in the hope that it will be
     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.


     You should have received a copy of the GNU General Public License
     along with the Code_Saturne Kernel; if not, write to the
     Free Software Foundation, Inc.,
     51 Franklin St, Fifth Floor,
     Boston, MA  02110-1301  USA

-----------------------------------------------------------------------*/
/*============================================================================*
 * Traitement de fichiers binaires Fortran de maniere portable sur les        *
 * architectures 'big endian' et 'little endian' (en prenant le cas           *
 * 'big endian' comme reference) depuis des programmes en C ou Fortran        *
 * utilisant la librairie C standard                                          *
 *                                                                            *
 * Bibliotheque : Code_Saturne, SYRTHES                    Copyright EDF 2000 *
 *============================================================================*/

#ifndef _FIC_BIN_F_H_
#define _FIC_BIN_F_H_

#undef  FORTRAN_WRAPER
#define FORTRAN_WRAPPER


/* Includes librairie */

#include "fortran_c.h"


/* Longueur maximale de nom de fichier en cas d'appel depuis du code Fortran */
#define LEN_MAX_NOM_FIC_BIN_F 256

/* Code d'erreur `local' pour fin de fichier  */
#define FIC_ERR_FIN         6532
#define FIC_ERR_FIN_MSG     "Fin de fichier"

/* Code d'erreur `local' pour contenu de fichier inattendu */
#define FIC_ERR_CONTENU     7653
#define FIC_ERR_CONTENU_MSG "Contenu de fichier inattendu"

/* Code d'erreur `local' pour nom Fortran de fichier trop long */
#define FIC_ERR_LEN_NOM     8765
#define FIC_ERR_LEN_NOM_MSG "Nom de fichier trop long"

/* Code d'erreur `local' pour taille enregistrement incompatible avec lecture */
#define FIC_ERR_SZE_ENR     9876
#define FIC_ERR_SZE_ENR_MSG "Taille d'enregistrement incompatible"


/*============================================================================*/
/*                              Structures locales                            */
/*============================================================================*/

typedef struct {

  FILE   *ptr;       /* Pointeur de fichier */
  int     end_swap;  /* 0 si l'on ne permute pas les octets, 1 sinon */

} fic_bin_t ;



/*============================================================================*/
/*                       Prototypes de fonctions publiques                    */
/*============================================================================*/

/*----------------------------------------------------------------------------*
 * Ouverture d'un fichier                                                     *
 *----------------------------------------------------------------------------*/

#ifdef FORTRAN_WRAPPER

/* Equivalent Fortran :

   subroutine openbf(unit, ierror)

   char(*) nomfic   !  -> Nom du fichier
   integer lnom     !  -> Longueur du nom du fichier
   char    modfic   !  -> Mode d'ouverture demande ('r', 'w', ou 'a')
   integer lmod     !  -> Longueur du nom du mode d'ouverture
   integer unit     !  -> Numero d'unite logique du fichier (0 a 99)
   integer ierror   ! <-  Code de retour (different de 0 en cas d'erreur)
*/

#if defined(CHAINE_F_VERS_C_LEN_FIN)
void fsymbol(openbf, OPENBF)
(
 char      *nomfic, /*  -> Nom du fichier                                     */
 integer_t *lnom  , /*  -> Longueur du nom de fichier                         */
 char      *modfic, /*  -> Mode d'ouverture demande ('r', 'w', ou 'a')        */
 integer_t *lmod  , /*  -> Longueur de la chaine de mode d'ouverture          */
 integer_t *unit  , /* <-  Numero d'unite logique du fichier (0 a 99)         */
 integer_t *ierror, /* <-  Code de retour                                     */
 integer_t  lennom, /*  -> Longueur du nom de fichier                         */
 integer_t  lenmod  /*  -> Longueur de la chaine de mode d'ouverture          */
);
#elif defined(CHAINE_F_VERS_C_STR_NUL)
void fsymbol(openbf, OPENBF)
(
 char      *nomfic, /*  -> Nom du fichier                                     */
 integer_t *lnom  , /*  -> Longueur du nom de fichier                         */
 char      *modfic, /*  -> Mode d'ouverture demande ('r', 'w', ou 'a')        */
 integer_t *lmod  , /*  -> Longueur de la chaine de mode d'ouverture          */
 integer_t *unit  , /* <-  Numero d'unite logique du fichier (0 a 99)         */
 integer_t *ierror  /* <-  Code de retour                                     */
);
#endif

#endif /* FORTRAN_WRAPPER */


integer_t ouvre_fic_bin_f
(
 char      *nomfic, /*  -> Nom du fichier                                     */
 char       modfic, /*  -> Mode d'ouverture demande ('r', 'w', ou 'a')        */
 fic_bin_t *fic     /* <-  Pointeur sur le descripteur de fichier             */
);


/*----------------------------------------------------------------------------*
 * Fermeture d'un fichier                                                     *
 *----------------------------------------------------------------------------*/

#ifdef FORTRAN_WRAPPER

/* Equivalent Fortran :

   subroutine closbf(unit, ierror)
   
   integer unit     !  -> Numero d'unite logique du fichier (0 a 99)
   integer ierror   ! <-  Code de retour (different de 0 en cas d'erreur)
*/

void fsymbol(closbf, CLOSBF)
(
 integer_t *unit  , /*  -> Numero d'unite logique du fichier (0 a 99)         */
 integer_t *ierror  /* <-  Code de retour                                     */
);

#endif /* FORTRAN_WRAPPER */


integer_t ferme_fic_bin_f
(
 fic_bin_t *fic     /*  -> Pointeur sur le descripteur de fichier             */
);


/*----------------------------------------------------------------------------*
 * Revenir au debut d'un fichier                                              *
 *----------------------------------------------------------------------------*/

#ifdef FORTRAN_WRAPPER

/* Equivalent Fortran :

   subroutine rewdbf(unit, ierror)
   
   integer unit     !  -> Numero d'unite logique du fichier (0 a 99)
   integer ierror   ! <-  Code de retour (different de 0 en cas d'erreur)
*/

void fsymbol(rewdbf, REWDBF)
(
 integer_t *unit  , /*  -> Numero d'unite logique du fichier (0 a 99)         */
 integer_t *ierror  /* <-  Code de retour                                     */
);

#endif /* FORTRAN_WRAPPER */


integer_t debut_fic_bin_f
(
 fic_bin_t *fic     /*  -> Pointeur sur le descripteur de fichier             */
);


/*----------------------------------------------------------------------------*
 * Tester si un fichier binaire est "big endian" ou "little endian".          *
 * On suppose que l'on connait la longueur du premier enregistrement.         *
 * Cette fonction doit s'appeller juste apres l'ouverture du fichier, et      *
 * configure le fichier de maniere a ce que les lectures ulterieures se       *
 * se fassent avec ou sans permutation des octets en fonction de ce test.     *
 *----------------------------------------------------------------------------*/

#ifdef FORTRAN_WRAPPER

/* Equivalent Fortran :

   subroutine tendbf(unit, ierror)

   integer unit     !  -> Numero d'unite logique du fichier (0 a 99)
   integer taille   !  -> Taille d'un element
   integer ierror   ! <-  Code de retour (different de 0 en cas d'erreur)
*/

void fsymbol(tendbf, OPENBF)
(
 integer_t *unit  , /*  -> Numero d'unite logique du fichier (0 a 99)         */
 integer_t *taille, /*  -> Taille des elements                                */
 integer_t *ierror  /* <-  Code de retour                                     */
);

#endif /* FORTRAN_WRAPPER */


integer_t test_end_fic_bin_f
(
 fic_bin_t *fic,    /*  -> Pointeur sur le descripteur de fichier             */
 int        trec    /*  -> Taille du premier l'enregistrement                 */
);


/*----------------------------------------------------------------------------*
 * Lecture d'un enregistrement binaire IEEE de type Fortran ;                 *
 *                                                                            *
 * On rappelle qu'un enregistrement commence et se termine par un marqueur    *
 * (entier code sur 4 octets indiquant la taille en octets des donnees        *
 * contenues dans l'enregistrement), permettant certaines operations de type  *
 * lecture a vide ou retour en arriere d'un enregistrement.                   *
 *                                                                            *
 * On fournit en argument un parametre mode indiquant le type de lecture :    *
 *                                                                            *
 *  mode = 0 : Lecture complete de l'enregistrement                           *
 *         1 : Lecture partielle de 'nombre' d'elements                       *
 *         2 : Saut a la fin de l'enregistement                               *
 *                                                                            *
 * On doit donc indiquer pour les modes 1 et 2 le nombre d'elements du meme   *
 * enregistrement deja lus lors d'appels precedents a ce sous-programme, et   *
 * si ce nombre est non nul, le nombre total d'elements de l'enregistrement   *
 * (calcule a la premiere lecture).                                           *
 *----------------------------------------------------------------------------*/

#ifdef FORTRAN_WRAPPER

/* Equivalent Fortran :

   subroutine readbf(unit, taille, nombre, mode, nbrlus, nbrtot, elems, ierror)
   
   integer unit     !  -> Numero d'unite logique du fichier (0 a 99)
   integer taille   !  -> Taille d'un element
   integer nombre   !  -> Nombre d'elements a lire au cours de cet appel
   integer mode     !  -> Mode de lecture (0, 1, ou 2)
   integer nbrlus   ! <-> Nombre d'elements de l'enregistrement deja lus
   integer nbrtot   ! <-> Nombre total d'elements de l'enregistrement
   ?       elems    ! <-> Tableau des elements
   integer ierror   ! <-  Code de retour (different de 0 en cas d'erreur)
*/

void fsymbol(readbf, READBF)
(
 integer_t *unit  , /*  -> Numero d'unite logique du fichier (0 a 99)         */
 integer_t *taille, /*  -> Taille des elements                                */
 integer_t *nombre, /*  -> Nombre d'elements a lire au cours de cet appel     */
 integer_t *mode  , /*  -> Mode de lecture de l'enregistrement (0, 1, ou 2)   */
 integer_t *nbrlus, /* <-> Nombre d'elements de l'enregistrement deja lus     */
 integer_t *nbrtot, /* <-> Nombre total d'elements de l'enregistrement        */
 void      *elems , /* <-> Tableau des elements                               */
 integer_t *ierror  /* <-  Code de retour                                     */
);

#endif /* FORTRAN_WRAPPER */

integer_t lit_fic_bin_f
(
 fic_bin_t *fic   , /*  -> Pointeur sur le descripteur de fichier             */
 integer_t  taille, /*  -> Taille des elements                                */
 integer_t  nombre, /*  -> Nombre d'elements a lire au cours de cet appel     */
 integer_t  mode  , /*  -> Mode de lecture de l'enregistrement (0, 1, ou 2)   */
 integer_t *nbrlus, /* <-> Nombre d'elements de l'enregistrement deja lus     */
 integer_t *nbrtot, /* <-> Nombre total d'elements de l'enregistrement        */
 void      *elems   /* <-> Tableau des elements                               */
);


/*----------------------------------------------------------------------------*
 * Ecriture d'un enregistrement binaire IEEE de type Fortran ;                *
 *                                                                            * 
 * On rappelle qu'un enregistrement commence et se termine par un marqueur    *
 * (entier code sur 4 octets indiquant la taille en octets des donnees        *
 * contenues dans l'enregistrement), permettant certaines operations de type  *
 * lecture a vide ou retour en arriere d'un enregistrement.                   *
 *                                                                            *
 * On fournit en argument un parametre mode indiquant le type d'ecriture :    *
 *                                                                            *
 *  mode = 0 : Ecriture complete de l'enregistrement                          *
 *         1 : Ecriture partielle de 'nombre' d'elements                      *
 *                                                                            *
 * On doit donc indiquer pour le mode 1 le nombre d'elements du meme          *
 * enregistrement deja ecrits lors d'appels precedents a ce sous-programme,   *
 * ainsi que le nombre total d'elements a ecrire.                             *
 *----------------------------------------------------------------------------*/

#ifdef FORTRAN_WRAPPER

/* Equivalent Fortran :

   subroutine writbf(unit, taille, nombre, mode, nbrecr, nbrtot, elems, ierror)
   
   integer unit     !  -> Numero d'unite logique du fichier (0 a 99)
   integer taille   !  -> Taille d'un element
   integer nombre   !  -> Nombre d'elements a ecrire au cours de cet appel
   integer mode     !  -> Mode de lecture (0 ou 1)
   integer nbrecr   ! <-> Nombre d'elements de l'enregistrement deja ecrits
   integer nbrtot   ! <-> Nombre total d'elements de l'enregistrement
   ?       elems    ! <-> Tableau des elements
   integer ierror   ! <-  Code de retour (different de 0 en cas d'erreur)
*/

void fsymbol(writbf, WRITBF)
(
 integer_t *ptrfic, /*  -> Numero d'unite logique du fichier (0 a 99)         */
 integer_t *taille, /*  -> Taille des elements                                */
 integer_t *nombre, /*  -> Nombre d'elements                                  */
 integer_t *mode  , /*  -> Mode d'ecriture de l'enregistrement (0 ou 1)       */
 integer_t *nbrecr, /* <-> Nombre d'elements de l'enregistrement deja ecrits  */
 integer_t *nbrtot, /* <-> Nombre total d'elements de l'enregistrement        */
 void      *elems,  /*  -> Tableau des elements                               */
 integer_t *ierror  /* <-  Code de retour                                     */
);

#endif /* FORTRAN_WRAPPER */


integer_t ecr_fic_bin_f
(
 fic_bin_t *fic   , /*  -> Pointeur sur descripteur de fichier                */
 integer_t  taille, /*  -> Taille des elements                                */
 integer_t  nombre, /*  -> Nombre d'elements a ecrire au cours de cet appel   */
 integer_t  mode  , /*  -> Mode d'ecriture de l'enregistrement (0 ou 1)       */
 integer_t *nbrecr, /* <-> Nombre d'elements de l'enregistrement deja ecrits  */
 integer_t *nbrtot, /* <-> Nombre total d'elements de l'enregistrement        */
 void      *elems   /* <-> Tableau des elements                               */
);

/*----------------------------------------------------------------------------*
 * Ecriture d'une chaine de caracteres correspondant a un numero d'erreur     *
 *----------------------------------------------------------------------------*/

#ifdef FORTRAN_WRAPPER

/* Equivalent Fortran :

   subroutine strebf(chaine, lchn, ierror)
   
   char(*) chaine   ! <-> Chaine de caracteres receptrice
   integer lchn     !  -> Longueur de la chaine receptrice
   integer ierror   !  -> Code d'erreur
*/

#ifdef CHAINE_F_VERS_C_LEN_FIN 
void fsymbol(strebf, STREBF)
(
 char      *chaine, /* <-  Chaine de caracteres receptrice                    */
 integer_t *lchn  , /*  -> Longueur de la chaine receptrice                   */
 integer_t *ierror, /*  -> Code d'erreur                                      */
 integer_t  lenchn  /*  -> Longueur de la chaine receptrice                   */
);
#elif defined(CHAINE_F_VERS_C_STR_NUL)
void fsymbol(strebf, STREBF)
(
 char      *chaine, /* <-  Chaine de caracteres receptrice                    */
 integer_t *lchn  , /*  -> Longueur de la chaine receptrice                   */
 integer_t *ierror  /*  -> Code d'erreur                                      */
);
#endif

#endif /* FORTRAN_WRAPPER */


void err_fic_bin_f
(
 char      *chaine, /* <-> Chaine de caracteres receptrice                    */
 integer_t  ierror, /*  -> Code d'erreur                                      */
 integer_t  lmaxch  /*  -> Longueur maximale de la chaine receptrice          */
);


#endif /* _FIC_BIN_F_H_ */
