#include <SyFi.h> 
#include <fstream>

using namespace GiNaC; 
using namespace SyFi; 
using namespace std; 

int main() {

    initSyFi(3); 

    archive ar; 

    symbol x0("x0"), x1("x1"), y0("y0"), y1("y1"), z0("z0"), z1("z1"); 

    ex p0 = lst(x0,y0,z0);
    ex p1 = lst(x1,y0,z0);
    ex p2 = lst(x0,y1,z0);
    ex p3 = lst(x0,y0,z1);

    Tetrahedron tetrahedron(p0,p1,p2,p3);

    ex repr = tetrahedron.repr();
    cout <<"t.repr "<<repr<<endl; 
    ar.archive_ex(repr, "repr"); 

    ex f = x*y*z;
    ex intf = tetrahedron.integrate(f); 
    cout <<"intf "<<intf<<endl; 
    ar.archive_ex(intf, "intf"); 

    /*
    ofstream vfile("tetrahedron_ex2.gar.v"); 
    vfile << ar; vfile.close(); 
    if(!compare_archives("tetrahedron_ex2.gar.v", "tetrahedron_ex2.gar.r")) { 
	    cerr << "Failure!" << endl;
	    return -1;
    }
    */

    return 0; 
}

