/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _TEXT_LINENR_WIDGET_H
#define _TEXT_LINENR_WIDGET_H

// sc
class TextModel;

// qt
#include <QtGui/QWidget>

class TextLineNrWidget : public QWidget
{
  typedef QWidget super;
  Q_OBJECT 

public:
  enum Flags
  {
    Empty  = 0x00,
    Left   = 0x01,   // text is right
    Right  = 0x02    // text is left
  };

  TextLineNrWidget( QWidget *parent=0, unsigned long flags = Left, const char *name=0 );
  virtual ~TextLineNrWidget();

  void setModel( TextModel *model );
  void setLineCnt( int l );

  void setFlags( unsigned long flags );

  QSize sizeHint() const;

public slots:
  void setScrollPosY( int y );

protected:
  void paintEvent( QPaintEvent * );

private:
  TextModel*    _model;       // data source

  int           _lnColumns;   // char columns
  int           _lnLeftPad;   // pixel
  int           _lnRightPad;  // pixel
  
  unsigned long _flags;       // see Flags enum

  int           _ypos;        // scroll position
};


#endif // _TEXT_LINENR_WIDGET_H

