/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SCROLL_POSITION_CALCULATOR_H
#define _SCROLL_POSITION_CALCULATOR_H

class ScrollPositionCalculator
{
public:
  int calcPos( int oldPos, int newPos, int curSize, int hintSize ) const
  {
    // if our current size is already more than we want, don't
    // scroll all.
    
    if( curSize > hintSize )
    {
      return 0;
    }

    // don't scroll into a negativ position

    if( newPos < 0 )
    {
      return 0;
    }

    // keep newPos less or equal to the highest possible scroll
    // position.

    if( newPos >= hintSize - curSize )
    {
      return hintSize - curSize;
    }

    // if we have more space than requested and the current
    // position is > 0, modify newPos in such a way that we
    // scroll back to position = 0

    // the negativ test is necessary because with quick resize
    // movements newPos calculation can get negativ..

    if( curSize + newPos > hintSize )
    {
      newPos -= curSize + newPos - hintSize;
      if( newPos < 0 )
      {
        newPos = 0;
      }
    }
    return newPos;
  }
};


#endif //  _SCROLL_POSITION_CALCULATOR_H

