(in-package :stumpwm)

(export '(show-menu load-menu-file))

(defvar *app-menu* nil "Where the menu structure is held")

(defun load-menu-file (file-name &key (strip 0))
  (with-open-file (file file-name)
    (when (char= #\# (peek-char nil file)) (read-line file))  ; Hack around the "autogenerated file" comment
    (let* ((*read-eval* nil)
           (list (list (read file))))
      (dotimes (i strip) (setf list (mapcan #'cdr list)))
      (setf *app-menu* (nconc *app-menu* list)))))

(defcommand show-menu () ()
  "Show the application menu"
  (let ((stack (list *app-menu*)))
    (loop
       (let ((choice
              (cdr (select-from-menu (current-screen)
                                     (append (first stack)
                                             (list (cons "Up a level" :up)))))))
         (cond
           ((not choice) (return))
           ((eq choice :up) (pop stack) (unless stack (return)))
           ((stringp choice) (run-shell-command choice) (return))
           (t (push choice stack)))))))

