/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand.function;

import adql.db.DBType;
import adql.db.FunctionDef;
import adql.parser.feature.LanguageFeature;
import adql.parser.grammar.ParseException;
import adql.query.ADQLList;
import adql.query.ADQLObject;
import adql.query.ClauseADQL;
import adql.query.TextPosition;
import adql.query.operand.ADQLOperand;
import adql.query.operand.UnknownType;
import adql.query.operand.function.ADQLFunction;
import adql.translator.ADQLTranslator;
import adql.translator.FunctionTranslator;
import adql.translator.TranslationException;
import java.lang.reflect.InvocationTargetException;

public class UserDefinedFunction
extends ADQLFunction
implements UnknownType {
    private char expectedType = (char)63;
    protected LanguageFeature languageFeature;
    protected FunctionDef definition = null;
    protected ADQLList<ADQLOperand> parameters;
    protected String functionName;

    protected UserDefinedFunction() {
        this("<unnamed>", null);
    }

    public UserDefinedFunction(String name, ADQLOperand[] params) throws NullPointerException {
        this.functionName = name;
        this.parameters = new ClauseADQL<ADQLOperand>();
        if (params != null) {
            for (ADQLOperand p : params) {
                this.parameters.add(p);
            }
        }
        this.generateLanguageFeature();
    }

    public UserDefinedFunction(UserDefinedFunction toCopy) throws Exception {
        this.functionName = toCopy.functionName;
        this.parameters = (ADQLList)toCopy.parameters.getCopy();
        this.setPosition(toCopy.getPosition() == null ? null : new TextPosition(toCopy.getPosition()));
        this.definition = toCopy.definition;
        this.languageFeature = toCopy.languageFeature;
    }

    @Override
    public final char getExpectedType() {
        return this.expectedType;
    }

    @Override
    public final void setExpectedType(char c) {
        this.expectedType = c;
    }

    @Override
    public final LanguageFeature getFeatureDescription() {
        return this.languageFeature;
    }

    public final FunctionDef getDefinition() {
        return this.definition;
    }

    public void setDefinition(FunctionDef def) throws IllegalArgumentException {
        if (!(def == null || def.name != null && this.getName() != null && this.getName().equalsIgnoreCase(def.name))) {
            throw new IllegalArgumentException("The parsed function name (" + this.getName() + ") does not match to the name of the given UDF definition (" + def.name + ").");
        }
        this.definition = def;
        if (this.definition == null) {
            this.generateLanguageFeature();
        } else {
            this.languageFeature = new LanguageFeature(this.definition);
        }
    }

    protected void generateLanguageFeature() {
        DBType unknownType = new DBType(DBType.DBDatatype.UNKNOWN);
        unknownType.type.setCustomType("type");
        FunctionDef.FunctionParam[] inputParams = new FunctionDef.FunctionParam[this.parameters.size()];
        for (int i = 1; i <= this.parameters.size(); ++i) {
            inputParams[i - 1] = new FunctionDef.FunctionParam("param" + i, unknownType);
        }
        try {
            FunctionDef fctDef = new FunctionDef(this.getName() == null ? "<unnamed>" : this.getName(), unknownType, inputParams);
            this.languageFeature = new LanguageFeature(fctDef);
        }
        catch (ParseException pe) {
            this.languageFeature = null;
        }
    }

    @Override
    public boolean isNumeric() {
        return this.definition == null || this.definition.isNumeric();
    }

    @Override
    public boolean isString() {
        return this.definition == null || this.definition.isString();
    }

    @Override
    public boolean isGeometry() {
        return this.definition == null || this.definition.isGeometry();
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        UserDefinedFunction copy = new UserDefinedFunction(this);
        copy.setDefinition(this.definition);
        return copy;
    }

    @Override
    public String getName() {
        return this.functionName;
    }

    @Override
    public ADQLOperand[] getParameters() {
        ADQLOperand[] params = new ADQLOperand[this.parameters.size()];
        int i = 0;
        for (ADQLOperand op : this.parameters) {
            params[i++] = op;
        }
        return params;
    }

    @Override
    public int getNbParameters() {
        return this.parameters.size();
    }

    @Override
    public ADQLOperand getParameter(int index) throws ArrayIndexOutOfBoundsException {
        return this.parameters.get(index);
    }

    @Override
    public ADQLOperand setParameter(int index, ADQLOperand replacer) throws ArrayIndexOutOfBoundsException, NullPointerException, Exception {
        ADQLOperand oldParam = this.parameters.set(index, replacer);
        this.setPosition(null);
        return oldParam;
    }

    public String translate(ADQLTranslator caller) throws TranslationException {
        if (this.definition != null && this.definition.withCustomTranslation()) {
            try {
                FunctionTranslator translator = this.definition.createTranslator();
                return translator.translate(this, caller);
            }
            catch (TranslationException te) {
                throw te;
            }
            catch (Exception ex) {
                throw new TranslationException("Impossible to translate the function \"" + this.getName() + "\" (" + this.toADQL() + ")! Cause: error with a custom FunctionTranslator: \"" + (ex instanceof InvocationTargetException ? "[" + ex.getCause().getClass().getSimpleName() + "] " + ex.getCause().getMessage() : ex.getMessage()) + "\".", ex);
            }
        }
        return null;
    }
}

