-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (SP_Parser_Goto)
procedure Scan_Goto_Table
  (State_No       : in     SP_Productions.Valid_States;
   Index          : in out Goto_Index;
   Goal_State     :    out SP_Productions.SP_State;
   Reduction_Goal :    out SP_Symbols.SP_Non_Terminal)
is
   Feasible_State : SP_Productions.SP_State;
   Table_Index    : Goto_Index;
begin
   Feasible_State := SP_Productions.No_State;
   Table_Index    := Index;
   while Table_Index < Goto_Index'Last and then Feasible_State /= State_No loop
      Feasible_State := SP_Productions.SP_State (Goto_Table (Table_Index) mod State_Size);
      if Feasible_State /= State_No then
         Table_Index := Table_Index + 1;
      end if;
   end loop;
   if Feasible_State = State_No then
      Goal_State     := SP_Productions.SP_State ((Goto_Table (Table_Index) / State_Size) mod State_Size);
      Reduction_Goal :=
        SP_Symbols.SP_Non_Terminal'Val (((Goto_Table (Table_Index) / Red_Goal) mod Red_Goal_Size) + First_Non_Terminal);
      Index          := Table_Index + 1;
   else
      Goal_State     := SP_Productions.No_State;
      Reduction_Goal := SP_Symbols.SP_Non_Terminal'First;
      Index          := Table_Index;
   end if;
end Scan_Goto_Table;
