-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

----------------------------------------------------------------------------------------
-- If more attributes need to be added as obsolete, it is recommended to follow
-- the structure of AttributeIsVisible, the skeleton of which is present here.

separate (Dictionary)
function Attribute_Is_Visible_But_Obsolete_Local
  (Name      : LexTokenManager.Lex_String;
   Prefix    : PrefixSort;
   Type_Mark : RawDict.Type_Info_Ref;
   Scope     : Scopes)
  return      Boolean
is
   Result : Boolean;

   --------------------------------------------------------------------------------

   function Type_Attribute_Is_Visible_But_Obsolete
     (Name      : LexTokenManager.Lex_String;
      Type_Mark : RawDict.Type_Info_Ref)
     return      Boolean
   --# global in CommandLineData.Content;
   --#        in Dict;
   --#        in LexTokenManager.State;
   is
      Result : Boolean;

      --------------------------------------------------------------------------------
      -- Case analysis here is derived from AARM A.5.3 (72.d - 72.f) and
      -- AARM A.5.4 (4.a - 4.c)
      --------------------------------------------------------------------------------
      function Type_Attribute_Is_Visible_But_Obsolete_95
        (Name      : LexTokenManager.Lex_String;
         Type_Mark : RawDict.Type_Info_Ref)
        return      Boolean
      --# global in Dict;
      --#        in LexTokenManager.State;
      is
         Result : Boolean;
      begin

         if LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                 Lex_Str2 => LexTokenManager.Safe_Emax_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                        Lex_Str2 => LexTokenManager.Emax_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                        Lex_Str2 => LexTokenManager.Small_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare
           (Lex_Str1 => Name,
            Lex_Str2 => LexTokenManager.Epsilon_Token) =
           LexTokenManager.Str_Eq then
            Result := Type_Is_Floating_Point (Type_Mark => Type_Mark) or else Type_Mark = Get_Unknown_Type_Mark;
         elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                    Lex_Str2 => LexTokenManager.Mantissa_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare
           (Lex_Str1 => Name,
            Lex_Str2 => LexTokenManager.Safe_Large_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare
           (Lex_Str1 => Name,
            Lex_Str2 => LexTokenManager.Safe_Small_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                        Lex_Str2 => LexTokenManager.Large_Token) =
           LexTokenManager.Str_Eq then
            Result := Type_Is_Real (Type_Mark => Type_Mark) or else Type_Mark = Get_Unknown_Type_Mark;
         else
            Result := False;
         end if;
         return Result;
      end Type_Attribute_Is_Visible_But_Obsolete_95;

   begin -- Type_Attribute_Is_Visible_But_Obsolete
      case CommandLineData.Content.Language_Profile is

         when CommandLineData.SPARK83 =>
            Result := False; -- Currently none such handled

         when CommandLineData.SPARK95_Onwards =>

            -- and for SPARK95 onwards ...
            Result := Type_Attribute_Is_Visible_But_Obsolete_95 (Name      => Name,
                                                                 Type_Mark => Type_Mark);
      end case;
      return Result;
   end Type_Attribute_Is_Visible_But_Obsolete;

begin -- Attribute_Is_Visible_But_Obsolete_Local
   if Type_Is_Private_Here (Type_Mark => Type_Mark,
                            Scope     => Scope) then
      Result := False;
   else
      case Prefix is
         when AType =>
            Result := Type_Attribute_Is_Visible_But_Obsolete (Name      => Name,
                                                              Type_Mark => Type_Mark);
         when ABaseType =>
            Result := False; -- Currently none such handled
         when AnObject =>
            Result := False; -- Currently none such handled
      end case;
   end if;
   return Result;
end Attribute_Is_Visible_But_Obsolete_Local;
