// Fill an n-tuple and write it to a file simulating measurement of 
// conductivity of a material in different conditions of pressure
// and temperature using branches.

void write_ntuple_to_file_advanced(
   const std::string& outputFileName="conductivity_experiment.root"
   ,unsigned int numDataPoints=1000000){
	// Initialise the TNtuple
	TTree cond_data("cond_data", "Example N-Tuple");

	// define the variables and book them for the ntuple
	float pot,cur,temp,pres;
	cond_data.Branch("Potential", &pot, "Potential/F");
	cond_data.Branch("Current", &cur, "Current/F");
	cond_data.Branch("Temperature", &temp, "Temperature/F");
	cond_data.Branch("Pressure", &pres, "Pressure/F");

	for (int i=0;i<numDataPoints;++i){
		// Fill it randomly to fake the acquired data
		pot=gRandom->Uniform(0.,10.)*gRandom->Gaus(1.,0.01);
		temp=gRandom->Uniform(250.,350.)+gRandom->Gaus(0.,0.3);
		pres=gRandom->Uniform(0.5,1.5)*gRandom->Gaus(1.,0.02);
		cur=pot/(10.+0.05*(temp-300.)-0.2*(pres-1.))*
                    gRandom->Gaus(1.,0.01);
		// write to ntuple
		cond_data.Fill();}

	// Open a file, save the ntuple and close the file
	TFile ofile(outputFileName.c_str(),"RECREATE");
	cond_data.Write();
	ofile.Close();
}
