% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk.KDE_GUI-functions.R
\name{rk.show.message}
\alias{rk.select.list}
\alias{rk.show.message}
\alias{rk.show.question}
\title{Message boxes and selection list using native KDE GUI}
\usage{
rk.show.message(message, caption = "Information", wait = TRUE)

rk.show.question(message, caption = "Question", button.yes = "yes",
  button.no = "no", button.cancel = "cancel")

rk.select.list(list, preselect = NULL, multiple = FALSE, title = NULL)
}
\arguments{
\item{message}{a string for the content of the message box.}

\item{caption}{a string for title of the message box.}

\item{wait}{a logical (not NA) indicating whether the R interpreter should
wait for the user's action, or run it asynchronously.}

\item{button.yes}{a string for the text label of the \bold{Yes} button. Can
be an empty string (\code{""}), in which case the button is not displayed
at all.}

\item{button.no}{a string used for the text label of the \bold{No} button,
similar to \code{button.yes}.}

\item{list}{a vector, coerced into a character vector.}

\item{multiple}{a logical (not NA), when \code{TRUE} multiple selection
selection is allowed.}

\item{title}{a string, for the window title of the displayed list}

\item{button.canel}{a string used for the text label of the \bold{Cancel}
button, similar to \code{button.yes}.}

\item{preselct}{a vector, coerced into a character vector, items to be
preselected.}
}
\value{
\code{rk.show.message} always returns \code{TRUE}, invisibly.

\code{rk.show.question} returns \code{TRUE} for \bold{Yes}, \code{FALSE} for
  \bold{No}, and \code{NULL} for \bold{Cancel} actions.

\code{rk.select.list} returns the value of \code{\link{select.list}}.
}
\description{
Multi-purpose pop-up message boxes and selection list using native KDE GUI
elements. The message boxes can be used either to show some information or
ask some question. The selection list can be used to get a vector of
selected items.
}
\details{
For \code{rk.show.question}, the R interpreter always waits for the user's
choice.

\code{rk.select.list} replaces \code{utils::select.list} for the running
session acting as a drop-in replacement for \code{tk_select.list}. Use
\code{.rk.backups$select.list} for the original \code{utils::select.list}
function (see Examples).
}
\examples{

require (rkward)

## Message boxes
if (rk.show.question ("Question:\\nDo you want to know about RKWard?", 
    button.yes = "Yes, I do!", button.no = "No, I don't care!", button.cancel = "")) {
  rk.show.message ("Message:\\nRKWard is a KDE GUI for R.", "RKWard Info")
} else {
  rk.show.message ("You must be joking!", "RKWard Info", wait = FALSE) ## Run asynchronously
}

## Selection lists:
rk.select.list (LETTERS, preselect = c("A", "E", "I", "O", "U"), 
  multiple = TRUE, title = "vowels")
.rk.backups$select.list (LETTERS, preselect = c("A", "E", "I", "O", "U"), 
  multiple = TRUE, title = "vowels")
}
\author{
Thomas Friedrichsmeier \email{rkward-devel@kde.org}
}
\seealso{
\code{\link{system}}, \code{\link{select.list}}
}
\keyword{utilities}

