#!/bin/sh
#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2009 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# -------------------------------------------------------------------------
GEODIR=${GEODIR-"../../../rheolef/nfem/data"}
SRCDIR=${SRCDIR-"../../../rheolef/fem/tst"}
BINDIR="../bin"

SRCDIR=${SRCDIR-"../../../rheolef/nfem/tst"}
GEODIR=${GEODIR-"../../../rheolef/fem/geo"}

RHEOLEF_BASIS_PATH=${RHEOLEF_BASIS_PATH-"../basis"}
RHEOLEF_NUMBERING_PATH=${RHEOLEF_NUMBERING_PATH-"../basis"}
RHEOLEF_FORM_ELEMENT_PATH=${RHEOLEF_FORM_ELEMENT_PATH-"../form_element"}
export RHEOLEF_BASIS_PATH
export RHEOLEF_NUMBERING_PATH
export RHEOLEF_FORM_ELEMENT_PATH

status=0

command="./space_gen2_tst -I${GEODIR} carre-v2 top bottom left right | ${BINDIR}/space -I${GEODIR} -"
echo "      $command"
eval $command | diff -bw ${SRCDIR}/carre-2d.space - > /dev/null
if test $? -ne 0; then status=1; echo "        => *NO*"; fi
exit $status


