#include "rheolef.h"
using namespace rheolef;
using namespace std;
int main(int argc, char**argv) {
  environment rheolef (argc, argv);
  Float tol = (argc > 1) ? atof(argv[1]) : 1e-10;
  field uh, ph;
  din >> catchmark("u")  >> uh
      >> catchmark("p")  >> ph;
  const space& Xh = uh.get_space();
  const space& Qh = ph.get_space();
  trial u (Xh), p (Qh); test v (Xh), q (Qh);
  form a  = integrate (2*ddot(D(u),D(v)));
  form b  = integrate (-div(u)*q);
  form mp = integrate (p*q);
  solver fact_mp (mp.uu());
  field m_ru = a*uh + b.trans_mult(ph);
  field m_rp = b*uh;
  m_ru["top"] = m_ru["bottom"] = 0;
  if (Xh.get_geo().dimension() == 3) {
    m_ru[1]["left"] = m_ru[1]["right"] = 0;
    m_ru["front"] = m_ru["back"] = 0;
  } else {
    m_ru["left"] = m_ru["right"] = 0;
  }
  field rp (Qh);
  rp.set_u() = fact_mp.solve(m_rp.u());
  Float res_u = m_ru.u().max_abs();
  Float res_p = sqrt(mp(rp,rp));
  Float res = max(res_u, res_p);
  Float p_constant = mp(ph, field(Qh,1.));
  derr << "check: residue(uh) = " << res_u << endl
       << "check: residue(ph) = " << res_p << endl
       << "check: residue     = " << res << endl
       << "m(p,1)             = " << p_constant << endl;
  return (res <= tol) ? 0 : 1;
}
