#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "burgers_diffusion_exact.icc"
int main(int argc, char**argv) {
  environment rheolef (argc, argv);
  Float err_expected = (argc > 1) ? atof(argv[1]) : 1;
  Float epsilon;
  din >> catchmark("epsilon") >> epsilon;
  branch even("t","u");
  Float t=0; field uh;
  Float err_linf_l2 = 0,
        err_l2_l2 = 0,
        err_linf_linf = 0,
        meas_omega = 0;
  size_t n = 0;
  bool have_meas_omega = false;
  dout << "# t err_l2(t) err_linf(t)" << endl;
  while (din >> even(t,uh)) {
    const geo& omega = uh.get_geo();
    if (!have_meas_omega) {
      meas_omega = integrate(omega);
      have_meas_omega = true;
    }
    quadrature_option_type qopt;
    qopt.set_order (2*uh.get_space().degree()+1);
    field pi_h_u = interpolate (uh.get_space(), u_exact(epsilon,t));
    Float err_linf = field(uh - pi_h_u).max_abs();
    Float err_l2 = sqrt(integrate (omega, sqr(uh - u_exact(epsilon,t)), qopt)/meas_omega);
    err_linf_linf = max(err_linf_linf, err_linf);
    err_linf_l2 = max(err_linf_l2, err_l2);
    err_l2_l2 += sqr(err_l2);
    dout << t << " " << err_l2 << " " << err_linf << endl;
    ++n;
  }
  err_l2_l2 = sqrt(err_l2_l2/n);
  dout << "# err_l2_l2     = " << err_l2_l2 << endl
       << "# err_linf_l2   = " << err_linf_l2 << endl
       << "# err_linf_linf = " << err_linf_linf << endl;
  return (err_linf_l2 <= err_expected) ? 0 : 1;
}
