#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "taylor_exact.icc"
int main(int argc, char**argv) {
  environment rheolef(argc, argv);
  Float err_linf_expected = (argc > 1) ? atof(argv[1]) : 1e+38;
  bool dump = (argc > 2);
  field uh; din >> uh;
  space Xh = uh.get_space();
  geo omega = Xh.get_geo();
  size_t k = Xh.degree();
  size_t d = omega.dimension();
  quadrature_option_type qopt;
  qopt.set_family(quadrature_option_type::gauss);
  qopt.set_order(2*k+1);
  string high_approx = "P"+itos(k+1)+"d";
  space Xh1 (omega, high_approx, "vector"),
        Qh1 (omega, high_approx);
  field eh = interpolate (Xh1, uh-u_exact());
  Float err_l2 = sqrt(integrate (omega, norm2(uh-u_exact()), qopt));
  Float err_linf = eh.max_abs();
  Float err_h1 = sqrt(integrate (omega, norm2(grad_h(eh)), qopt)
                    + integrate (omega.sides(), (1/h_local())*norm2(jump(eh)), qopt));
  derr << "err_l2   = " << err_l2 << endl
       << "err_linf = " << err_linf << endl
       << "err_h1   = " << err_h1 << endl;
  if (dump) {
    dout << catchmark("uh") << uh 
         << catchmark("u")  << interpolate (Xh, u_exact())
         << catchmark("eu") << eh;
  }
  return (err_linf <= err_linf_expected) ? 0 : 1;
}
