///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
//
// geo adaptation
//
// author:
//      Pierre.Saramito@imag.fr
//
// date: 27 january 2006
//
// ============================================================================
//  includes
// ============================================================================

#include "rheolef/geo.h"
#include "rheolef/field.h"
using namespace std;
namespace rheolef {


// =======================================================================
//! calculate a metric adapted to the criterion field u0
// =======================================================================
void
georep_calculate_metric (const field& u0, field& metric, const adapt_option_type& opt)
{
    if (opt.generator == "bamg") {
        georep_calculate_metric_bamg (u0, metric, opt);
    }
	else error_macro("Metric generator " << opt.generator << " not interfaced.");
}

void
georep_calculate_metric (const Vector<field>& criteria, field& metric, const adapt_option_type& opt)
{
    if (opt.generator == "bamg") {
        georep_calculate_metric_bamg (criteria, metric, opt);
    }
	else error_macro("Metric generator " << opt.generator << " not interfaced.");
}

// =======================================================================
// adapt according to a metric
// =======================================================================
void
georep_metric_adapt (const field& mh, georep& adapt_g, const adapt_option_type& opt)
{
    if (opt.generator == "bamg") {
        georep_metric_adapt_bamg (mh, adapt_g, opt);
    } else {
        error_macro("anisotropic mesh generator `" << opt.generator << "' not supported.");
    }
}

// =======================================================================
// adapt
// =======================================================================
void
georep_adapt (const field& u0, georep& adapt_g, const adapt_option_type& opt, bool do_interpolate)
{
    if (opt.generator == "bamg" || opt.generator == "bamg-0.68") {
        georep_adapt_bamg (u0, adapt_g, opt, do_interpolate);
    } else if (opt.generator == "grummp") {
        georep_adapt_grummp (u0, adapt_g, opt, do_interpolate);
    } else {
	error_macro ("unrecognized mesh generator `" << opt.generator << "'");
    }
}
}// namespace rheolef
