#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "embankment.h"
field criteria(Float lambda, const field& uh) {
  string approx = (uh.get_approx() == "P2") ? "P1d" : "P0";
  if (approx == "P0") return sqrt(sqr(uh[0])+sqr(uh[1]));
  space Th  (uh.get_geo(), approx, "tensor");
  space Xh  (uh.get_geo(), approx);
  form two_D  (uh.get_space(), Th, "2D");
  form div    (uh.get_space(), Xh, "div");
  form mt (Th, Th, "mass");
  form m  (Xh, Xh, "mass");
  form inv_mt (Th, Th, "inv_mass");
  form inv_m  (Xh, Xh, "inv_mass");
  field qh      = inv_m*(div*uh);
  field two_Duh = inv_mt*(two_D*uh);
  return sqrt(lambda*sqr(qh) +   sqr(field(two_Duh(0,0)))
         + sqr(field(two_Duh(1,1))) + 2*sqr(field(two_Duh(0,1))));
}
field solve(const geo& omega, const string& approx, Float lambda) {
  space Vh = embankment_space(omega, approx);
  field uh (Vh, 0.0), fh (Vh, 0.0);
  fh[1] = -1.0;
  form m  (Vh, Vh, "mass");
  form a1 (Vh, Vh, "div_div");
  form a2 (Vh, Vh, "2D_D");
  form a = lambda*a1 + a2;
  ssk<Float> fact = ldlt(a.uu);
  uh.u = fact.solve (m.uu*fh.u + m.ub*fh.b - a.ub*uh.b);
  return uh;
}
int main(int argc, char**argv) {
  const Float lambda = 1;
  geo  omega_h (argv[1]);
  string approx  = (argc > 2) ? argv[2] : "P1";
  size_t n_adapt = (argc > 3) ? atoi(argv[3]) : 5;
  adapt_option_type options;
  options.hcoef = 1.1;
  options.hmin  = 0.004;
  for (size_t i = 0; true; i++) {
      field uh = solve(omega_h, approx, lambda);
      orheostream o (omega_h.name(), "mfield");
      o << catchmark("lambda")  << lambda << endl
        << catchmark("u")       << uh;
      if (i == n_adapt) break;
      field ch = criteria(lambda,uh);
      omega_h  = geo_adapt(ch, options);
      omega_h.save();
  }
}
