// Code generated by go-swagger; DO NOT EDIT.

//
// Copyright 2021 The Sigstore Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package entries

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/sigstore/rekor/pkg/generated/models"
)

// GetLogEntryByUUIDOKCode is the HTTP code returned for type GetLogEntryByUUIDOK
const GetLogEntryByUUIDOKCode int = 200

/*
GetLogEntryByUUIDOK Information needed for a client to compute the inclusion proof

swagger:response getLogEntryByUuidOK
*/
type GetLogEntryByUUIDOK struct {

	/*
	  In: Body
	*/
	Payload models.LogEntry `json:"body,omitempty"`
}

// NewGetLogEntryByUUIDOK creates GetLogEntryByUUIDOK with default headers values
func NewGetLogEntryByUUIDOK() *GetLogEntryByUUIDOK {

	return &GetLogEntryByUUIDOK{}
}

// WithPayload adds the payload to the get log entry by Uuid o k response
func (o *GetLogEntryByUUIDOK) WithPayload(payload models.LogEntry) *GetLogEntryByUUIDOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get log entry by Uuid o k response
func (o *GetLogEntryByUUIDOK) SetPayload(payload models.LogEntry) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetLogEntryByUUIDOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty map
		payload = models.LogEntry{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// GetLogEntryByUUIDNotFoundCode is the HTTP code returned for type GetLogEntryByUUIDNotFound
const GetLogEntryByUUIDNotFoundCode int = 404

/*
GetLogEntryByUUIDNotFound The content requested could not be found

swagger:response getLogEntryByUuidNotFound
*/
type GetLogEntryByUUIDNotFound struct {
}

// NewGetLogEntryByUUIDNotFound creates GetLogEntryByUUIDNotFound with default headers values
func NewGetLogEntryByUUIDNotFound() *GetLogEntryByUUIDNotFound {

	return &GetLogEntryByUUIDNotFound{}
}

// WriteResponse to the client
func (o *GetLogEntryByUUIDNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(404)
}

/*
GetLogEntryByUUIDDefault There was an internal error in the server while processing the request

swagger:response getLogEntryByUuidDefault
*/
type GetLogEntryByUUIDDefault struct {
	_statusCode int

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetLogEntryByUUIDDefault creates GetLogEntryByUUIDDefault with default headers values
func NewGetLogEntryByUUIDDefault(code int) *GetLogEntryByUUIDDefault {
	if code <= 0 {
		code = 500
	}

	return &GetLogEntryByUUIDDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get log entry by UUID default response
func (o *GetLogEntryByUUIDDefault) WithStatusCode(code int) *GetLogEntryByUUIDDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get log entry by UUID default response
func (o *GetLogEntryByUUIDDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithPayload adds the payload to the get log entry by UUID default response
func (o *GetLogEntryByUUIDDefault) WithPayload(payload *models.Error) *GetLogEntryByUUIDDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get log entry by UUID default response
func (o *GetLogEntryByUUIDDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetLogEntryByUUIDDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
