<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:marc="http://www.loc.gov/MARC21/slim" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>

	<xsl:template match="/">
		<html>
			<xsl:apply-templates/>
		</html>
	</xsl:template>

	<xsl:template match="marc:leader">
		<p>LEADER</p>
		<xsl:variable name="leader" select="text()"/>
		<xsl:variable name="leader5" select="substring($leader,6,1)"/><!-- record status -->
		<xsl:variable name="leader6" select="substring($leader,7,1)"/><!-- type of record -->
		<xsl:variable name="leader7" select="substring($leader,8,1)"/><!-- bibliographic level: mono, series, etc. -->
		<xsl:variable name="leader8" select="substring($leader,9,1)"/><!-- type of control -->
		<xsl:variable name="leader9" select="substring($leader,10,1)"/><!-- character encoding a=UTF-8; blank = MARC-8 -->
		<xsl:variable name="leader17" select="substring($leader,18,1)"/><!-- encoding level -->
		<xsl:variable name="leader18" select="substring($leader,19,1)"/><!-- descriptive cataloguing form -->
		<xsl:variable name="leader19" select="substring($leader,20,1)"/><!-- linked record requirement -->
		<xsl:element name="entry">
			<xsl:choose>
				<xsl:when test="$leader6='a'">
					<xsl:attribute name="type">BOOK</xsl:attribute>
				</xsl:when>
				<xsl:when test="$leader6='c'|$leader6='d'">
					<xsl:attribute name="type">MUSIC</xsl:attribute>
				</xsl:when>
				<xsl:when test="$leader6='e'|$leader6='f'">
					<xsl:attribute name="type">MAP</xsl:attribute>
				</xsl:when>
				<xsl:when test="$leader6='g'">
					<xsl:attribute name="type">ADVS</xsl:attribute>
				</xsl:when>
				<xsl:when test="$leader6='i'|$leader6='j'">
					<xsl:attribute name="type">SOUND</xsl:attribute>
				</xsl:when>
				<xsl:when test="$leader6='k'|$leader6='r'">
					<xsl:attribute name="type">ART</xsl:attribute>
				</xsl:when>
				<xsl:when test="$leader6='m'">
					<xsl:attribute name="type">DATA</xsl:attribute>
				</xsl:when>
				<xsl:when test="$leader6='o'|$leader6='p'|$leader6='t'">
					<xsl:attribute name="type">GEN</xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="type">GEN</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:call-template name="part"/>
			<xsl:call-template name="publication"/>
			<xsl:call-template name="set"/>
			<xsl:call-template name="libinfo"/>
			<xsl:call-template name="contents"/>
		</xsl:element>
	</xsl:template>
	
	<xsl:template name="author">
		
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=020]">
		<p>INTERNATIONAL STANDARD BOOK NUMBER
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>International Standard Book Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=022]">
		<p>INTERNATIONAL STANDARD SERIAL NUMBER
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>International Standard Serial Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=027]">
		<p>STANDARD TECHNICAL REPORT NUMBER
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Standard Technical Report Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=028]">
		<p>PUBLISHER NUMBER FOR MUSIC
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Publisher number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Source:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=033]">
		<p>DATE/TIME AND PLACE OF AN EVENT
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Formatted date/time:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Geographic classification area code:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Geographic classification subarea code:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=036]">
		<p>ORIGINAL STUDY NUMBER FOR COMPUTER DATA FILES
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Original study number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Source (agency assigning number):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=044]">
		<p>COUNTRY OF PUBLISHING/PRODUCING ENTITY CODE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Country of publishing/producing entity code:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Local subentity code:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>ISO subentity code:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=050]">
		<p>LIBRARY OF CONGRESS CALL NUMBER
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Classification number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Item number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Supplementary class number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=055]">
		<p>CALL NUMBERS/CLASS NUMBERS ASSIGNED IN CANADA
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Classification number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Item number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=060]">
		<p>NATIONAL LIBRARY OF MEDICINE CALL NUMBER
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Classification number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Item number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=070]">
		<p>NATIONAL AGRICULTURAL LIBRARY CALL NUMBER
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Classification number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Item number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=072]">
		<p>SUBJECT CATEGORY CODE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Subject category code:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>Subject category code subdivision:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=080]">
		<p>UNIVERSAL DECIMAL CLASSIFICATION NUMBER
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field link and sequence number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Universal Decimal Classification number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Item number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>Common auxiliary subdivision:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Edition identifier:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=082]">
		<p>DEWEY DECIMAL CALL NUMBER
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field link and sequence number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Classification number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>DDC number--abridged NST version:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Edition number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=086]">
		<p>GOVERNMENT DOCUMENT CLASSIFICATION NUMBER
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Classification number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Cancelled/invalid classification number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Number source:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=088]">
		<p>REPORT NUMBER
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Report number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Cancelled/invalid report number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=090]">
		<p>LOCAL CALL NUMBER
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Local class number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Local Cutter number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=091]">
		<p>MICROFILM SHELF LOCATION
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Microfilm shelf location:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=100]">
		<p>MAIN ENTRY--PERSONAL NAME
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Personal name:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Titles and other words associated with a name:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Dates associated with a name:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Relator term:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Attribution qualifier:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Fuller form of name:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Affiliation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='4']">
				<li>Relator code:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=110]">
		<p>MAIN ENTRY--CORPORATE NAME
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Corporate name or jurisdiction name as entry element:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Subordinate unit:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Location of meeting:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Date of meeting or treaty signing:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Relator term:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Date of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section/meeting:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Affiliation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='4']">
				<li>Relator code:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=111]">
		<p>MAIN ENTRY--MEETING NAME
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Meeting name or jurisdiction name as entry element:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Number (BK CF MP MU SE VM MX):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Location of meeting:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Date of meeting:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Subordinate unit:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Date of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section/meeting:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Name of meeting following jurisdiction name entry element:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Affiliation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='4']">
				<li>Relator code:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=130]">
		<p>MAIN ENTRY--UNIFORM TITLE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Uniform title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Date of treaty signing:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Date of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Medium of performance for music:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Arranged statement for music:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Key for music:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Version:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=210]">
		<p>ABBREVIATED TITLE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field link and sequence number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Abbreviated title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Qualifying information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=211]">
		<p>ACRONYM OR SHORTENED TITLE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Acronym or shortened title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=212]">
		<p>VARIANT ACCESS TITLE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Variant access title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=214]">
		<p>AUGMENTED TITLE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Augmented title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=222]">
		<p>KEY TITLE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Key title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Qualifying information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=240]">
		<p>UNIFORM TITLE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Uniform title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Date of treaty signing:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Date of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Medium of performance for music:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Arranged statement for music:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Key for music:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Version:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=241]">
		<p>ROMANIZED TITLE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Romanized title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=243]">
		<p>COLLECTIVE UNIFORM TITLE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Uniform title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Date of treaty signing:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Date of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Medium of performance for music:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Arranged statement for music:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Key for music:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Version:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=245]">
		<p>TITLE STATEMENT
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Remainder of title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Remainder of title page transcription/statement of responsibility:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Designation of section:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Name of part/section (SE):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Inclusive dates:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Bulk dates:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Version:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=246]">
		<p>VARYING FORM OF TITLE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Title proper/short title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Remainder of title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Designation of section:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Name of part/section (SE):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Designation of volume and issue number and/or date of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>Display text:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='5']">
				<li>Institution to which field applies:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=247]">
		<p>FORMER TITLE OR TITLE VARIATIONS
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Title proper/short title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Remainder of title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Designation of section:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Name of part/section (SE):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Designation of volume and issue number and/or date of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>International Standard Serial Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=250]">
		<p>EDITION STATEMENT
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Edition statement:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Remainder of edition statement:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=254]">
		<p>MUSICAL PRESENTATION STATEMENT
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Musical presentation statement:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=255]">
		<p>CARTOGRAPHIC MATHEMATICAL DATA
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Statement of scale:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Statement of projection:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Statement of coordinates:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Statement of zone:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Statement of equinox:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Outer G-ring coordinate pairs:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Exclusion G-ring coordinate pairs:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=256]">
		<p>COMPUTER FILE CHARACTERISTICS
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Computer file characteristics:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=257]">
		<p>COUNTRY OF PRODUCING ENTITY FOR ARCHIVAL FILMS
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Country of producing entity for archival films:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=260]">
		<p>PUBLICATION, DISTRIBUTION, ETC. (IMPRINT)
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Place of publication, distribution, etc.:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Name of publisher, distributor, etc.:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Date of publication, distribution, etc.:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Place of manufacture:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Manufacturer:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Date of manufacture:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field link and sequence number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=263]">
		<p>PROJECTED PUBLICATION DATE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field link and sequence number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Projected publication date:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=362]">
		<p>DATES OF PUBLICATION AND/OR SEQUENTIAL DESIGNATION
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field link and sequence number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Dates of publication and/or sequential designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Source of information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=440]">
		<p>SERIES STATEMENT/ADDED ENTRY--TITLE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Volume number/sequential designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>International Standard Serial Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=490]">
		<p>SERIES STATEMENT
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Series statement:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Library of Congress call number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Volume number/sequential designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>International Standard Serial Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=500]">
		<p>GENERAL NOTE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>General note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Library of Congress call number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>International Standard Serial Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Source of note information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='5']">
				<li>Institution to which field applies:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=501]">
		<p>WITH NOTE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>With note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='5']">
				<li>Institution to which field applies:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=502]">
		<p>DISSERTATION NOTE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Dissertation note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=503]">
		<p>BIBLIOGRAPHIC HISTORY NOTE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Bibliographic history note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=504]">
		<p>BIBLIOGRAPHY, ETC. NOTE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Bibliography, etc. note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Number of references:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=505]">
		<p>FORMATTED CONTENTS NOTE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field link and sequence number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Formatted contents note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Statement of responsibility:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Uniform Resource Identifier:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=508]">
		<p>CREATION/PRODUCTION CREDITS NOTE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Creation/production credits note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=511]">
		<p>PARTICIPANT OR PERFORMER NOTE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Participant or performer note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=512]">
		<p>EARLIER OR LATER VOLUMES SEPARATELY CATALOGED NOTE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Earlier or later volumes separately cataloged note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=513]">
		<p>TYPE OF REPORT AND PERIOD COVERED NOTE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Type of report:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Period covered:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=515]">
		<p>NUMBERING PECULIARITIES NOTE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Numbering peculiarities note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Source of note information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=516]">
		<p>TYPE OF COMPUTER FILE OR DATA NOTE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Type of computer file or data note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=517]">
		<p>CATEGORIES OF FILMS NOTE (ARCHIVAL)
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Different formats:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Content descriptors:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Additional animation techniques:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=520]">
		<p>SUMMARY, ETC.
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field link and sequence number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Summary, etc.:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Expansion of summary note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Uniform Resource Identifier:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Source of note information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=524]">
		<p>PREFERRED CITATION OF DESCRIBED MATERIALS NOTE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Preferred citation of described materials note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Source of schema used:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=525]">
		<p>SUPPLEMENT NOTE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Supplement note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Source of note information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=533]">
		<p>REPRODUCTION NOTE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Type of reproduction:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Place of reproduction:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Agency responsible for reproduction:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Date of reproduction:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Physical description of reproduction:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Series statement of reproduction:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Dates of publication and/or sequential designation of issues reproduced:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Note about reproduction:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='7']">
				<li>Fixed-length data elements of reproduction:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=534]">
		<p>ORIGINAL VERSION NOTE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Main entry of original:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Edition statement of original:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Publication, distribution, etc. of original:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Physical description, etc. of original:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Series statement of original:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Key title of original:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Location of original:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Material specific details:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Note about original:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Introductory phrase:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title statement of original:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>International Standard Serial Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>International Standard Book Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=545]">
		<p>BIOGRAPHICAL OR HISTORICAL DATA
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field link and sequence number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Biographical or historical data:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Expansion:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Uniform Resource Identifier:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=546]">
		<p>LANGUAGE NOTE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Language note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Information code or alphabet:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Source of note information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=547]">
		<p>FORMER TITLE COMPLEXITY NOTE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Former title complexity note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Source of note information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=550]">
		<p>ISSUING BODY NOTE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Issuing body note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Source of note information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=552]">
		<p>ENTITY AND ATTRIBUTE INFORMATION NOTE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field link and sequence number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Entity type label:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Entity type definition and source:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Attribute label:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Attribute definition and source:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Enumerated domain value:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Enumerated domain value definition and source:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Range domain minimum and maximum:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Codeset name and source:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>Unrepresentable domain:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Attribute units of measurement and resolution:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Beginning date and ending date of attribute values:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Attribute value accuracy:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Attribute value accuracy explanation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Attribute measurement frequency:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Entity and attribute overview:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Entity and attribute detail citation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Uniform Resource Identifier:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Display note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=555]">
	<xsl:template match="marc:datafield[@tag=570]">
		<p>EDITOR NOTE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Editor note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Source of note information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=571]">
		<p>VOLUNTEERS NOTE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Volunteers note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Special requirements:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=572]">
		<p>AFFILIATION AND OTHER RELATIONSHIPS NOTE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Affiliation and other relationships note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=573]">
		<p>CREDENTIALS NOTE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Credentials note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=582]">
		<p>RELATED COMPUTER FILES NOTE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Related computer files note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=600]">
		<p>SUBJECT ADDED ENTRY--PERSONAL NAME
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field link and sequence number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Personal name:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Numeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Titles and other words associated with a name:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Dates associated with a name:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Relator term:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Date of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Attribution qualifier:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Language of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Medium of performance for music:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Arranged statement for music:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Fuller form of name:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Key for music:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Version:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Affiliation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Form subdivision:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>General subdivision:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>Chronological subdivision:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Geographic subdivision:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Source of heading or term:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='4']">
				<li>Relator code:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=610]">
		<p>SUBJECT ADDED ENTRY--CORPORATE NAME
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Corporate name or jurisdiction name as entry element:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Subordinate unit:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Location of meeting:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Date of meeting or treaty signing:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Relator term:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Date of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Language of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Medium of performance for music:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section/meeting:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Arranged statement for music:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Key for music:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Version:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Affiliation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Form subdivision:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>General subdivision:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>Chronological subdivision:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Geographic subdivision:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Source of heading or term:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='4']">
				<li>Relator code:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=611]">
		<p>SUBJECT ADDED ENTRY--MEETING NAME
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Meeting name or jurisdiction name as entry element:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Number (BK CF MP MU SE VM MX):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Location of meeting:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Date of meeting:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Subordinate unit:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Date of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Language of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section/meeting:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Name of meeting following jurisdiction name entry element:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Version:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Affiliation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Form subdivision:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>General subdivision:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>Chronological subdivision:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Geographic subdivision:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Source of heading or term:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='4']">
				<li>Relator code:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=630]">
		<p>SUBJECT ADDED ENTRY--UNIFORM TITLE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Uniform title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Date of treaty signing:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Date of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Language of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Medium of performance for music:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Arranged statement for music:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Key for music:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Version:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Form subdivision:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>General subdivision:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>Chronological subdivision:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Geographic subdivision:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Source of heading or term:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=650]">
		<p>SUBJECT ADDED ENTRY--TOPICAL TERM
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Topical term or geographic name as entry element:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Topical term following geographic name as entry element:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Location of event:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Active dates:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Relator term:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Form subdivision:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>General subdivision:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>Chronological subdivision:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Geographic subdivision:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Source of heading or term:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=651]">
		<p>SUBJECT ADDED ENTRY--GEOGRAPHIC NAME
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Geographic name:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Geographic name following place entry element:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Form subdivision:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>General subdivision:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>Chronological subdivision:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Geographic subdivision:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Source of heading or term:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=652]">
		<p>SUBJECT ADDED ENTRY--REVERSED GEOGRAPHIC
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Geographic name of place element:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>General subdivision:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>Chronological subdivision:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Geographic subdivision:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=653]">
		<p>INDEX TERM--UNCONTROLLED
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Uncontrolled term:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=654]">
		<p>SUBJECT ADDED ENTRY--FACETED TOPICAL TERMS
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Focus term:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Non-focus term:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Facet/hierarchy designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Form subdivision:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>Chronological subdivision:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Geographic subdivision:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Source of heading or term:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Material specified:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=655]">
		<p>INDEX TERM--GENRE/FORM/PHYSICAL CHARACTERISTICS
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field link and sequence number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Genre/form/physical characteristics:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Non-focus term:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Facet/hierarchy designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Form subdivision:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>General subdivision:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>Chronological subdivision:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Geographic subdivision:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Source of term:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='5']">
				<li>Institution to which field applies:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=656]">
		<p>INDEX TERM--OCCUPATION
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Occupation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Form subdivision:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>General subdivision:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>Chronological subdivision:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Geographic subdivision:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Source of term:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=657]">
		<p>INDEX TERM--FUNCTION
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Function:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Form subdivision:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>General subdivision:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>Chronological subdivision:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Geographic subdivision:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Source of term:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=658]">
		<p>INDEX TERM--CURRICULUM OBJECTIVE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Main curriculum objective:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Subordinate curriculum objective:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Curriculum code:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Correlation factor:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Source of term:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=700]">
		<p>ADDED ENTRY--PERSONAL NAME
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field link and sequence number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Personal name:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Numeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Titles and other words associated with a name:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Dates associated with a name:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Relator term:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Date of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Attribution qualifier:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Language of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Medium of performance for music:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Arranged statement for music:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Fuller form of name:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Key for music:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Version:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Affiliation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>International Standard Serial Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='4']">
				<li>Relator code:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='5']">
				<li>Institution to which field applies:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=705]">
		<p>ADDED ENTRY--PERSONAL NAME (PERFORMER)
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Personal name:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Numeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Titles and other words associated with a name:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Dates associated with a name:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Relator term:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Date of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Language of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Medium of performance for music:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Arranged statement for music:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Key for music:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Version:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=710]">
		<p>ADDED ENTRY--CORPORATE NAME
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Corporate name or jurisdiction name as entry element:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Subordinate unit:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Location of meeting:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Date of meeting or treaty signing:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Relator term:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Date of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Language of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Medium of performance for music:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section/meeting:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Arranged statement for music:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Key for music:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Version:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Affiliation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>International Standard Serial Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='4']">
				<li>Relator code:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='5']">
				<li>Institution to which field applies:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=711]">
		<p>ADDED ENTRY--MEETING NAME
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Meeting name or jurisdiction name as entry element:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Number (BK CF MP MU SE VM MX):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Location of meeting:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Date of meeting:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Subordinate unit:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Date of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Language of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section/meeting:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Name of meeting following jurisdiction name entry element:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Version:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Affiliation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>International Standard Serial Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='4']">
				<li>Relator code:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='5']">
				<li>Institution to which field applies:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=715]">
		<p>ADDED ENTRY--CORPORATE NAME-PERFORMING GROUP
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Corporate name or jurisdiction name:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Subordinate unit:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Relator term:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Date of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Language of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Medium of performance for music:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section/meeting:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Arranged statement for music:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Key for music:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Version:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Nonprinting information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=720]">
		<p>ADDED ENTRY--UNCONTROLLED NAME
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Name:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Relator term:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='4']">
				<li>Relator code:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=730]">
		<p>ADDED ENTRY--UNIFORM TITLE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Uniform title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Date of treaty signing:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Date of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Language of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Medium of performance for music:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Arranged statement for music:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Key for music:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Version:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>International Standard Serial Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='5']">
				<li>Institution to which field applies:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=740]">
		<p>ADDED ENTRY--UNCONTROLLED RELATED/ANALYTICAL TITLE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Uncontrolled related/analytical title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='5']">
				<li>Institution to which field applies:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=752]">
		<p>ADDED ENTRY--HIERARCHICAL PLACE NAME
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Country:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>State, province, territory:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>County, region, islands area:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>City:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=754]">
		<p>ADDED ENTRY--TAXONOMIC IDENTIFICATION
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Taxonomic name/taxonomic hierarchical category:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Source of taxonomic identification:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=760]">
		<p>MAIN SERIES ENTRY
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Main entry heading:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Edition:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Qualifying information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Place, publisher, and date of publication:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Relationship information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>Display text:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Physical description:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Material-specific details:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Other item identifier:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Parallel title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Uniform title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='w']">
				<li>Record control number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>International Standard Serial Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>CODEN designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='7']">
				<li>Control subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=762]">
		<p>SUBSERIES ENTRY
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Main entry heading:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Edition:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Qualifying information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Place, publisher, and date of publication:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Relationship information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Physical description of source:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>Display text:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Material-specific details:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Other item identifier:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Parallel title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Uniform title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='w']">
				<li>Record control number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>International Standard Serial Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>CODEN designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='7']">
				<li>Control subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=765]">
		<p>ORIGINAL LANGUAGE ENTRY
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Main entry heading:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Edition:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Qualifying information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Place, publisher, and date of publication:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Relationship information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Physical description of source:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>Display text:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Series data for related item:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Material-specific details:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Other item identifier:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Parallel title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Report number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Uniform title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Standard Technical Report Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='w']">
				<li>Record control number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>International Standard Serial Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>CODEN designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>International Standard Book Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='7']">
				<li>Control subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=767]">
		<p>TRANSLATION ENTRY
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Main entry heading:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Edition:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Qualifying information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Place, publisher, and date of publication:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Relationship information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Physical description of source:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>Display text:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Series data for related item:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Material-specific details:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Other item identifier:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Parallel title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Report number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Uniform title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Standard Technical Report Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='w']">
				<li>Record control number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>International Standard Serial Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>CODEN designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>International Standard Book Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='7']">
				<li>Control subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=770]">
		<p>SUPPLEMENT/SPECIAL ISSUE ENTRY
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Main entry heading:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Edition:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Qualifying information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Place, publisher, and date of publication:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Relationship information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Physical description of source:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>Display text:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Series data for related item:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Material-specific details:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Other item identifier:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Parallel title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Report number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Uniform title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Standard Technical Report Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='w']">
				<li>Record control number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>International Standard Serial Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>CODEN designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>International Standard Book Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='7']">
				<li>Control subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=772]">
		<p>PARENT RECORD ENTRY
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Main entry heading:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Edition:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Qualifying information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Place, publisher, and date of publication:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Relationship information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Physical description of source:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>Display text:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Series data for related item:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Material-specific details:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Other item identifier:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Parallel title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Report number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Uniform title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Standard Technical Report Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='w']">
				<li>Record control number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>International Standard Serial Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>CODEN designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>International Standard Book Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='7']">
				<li>Control subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=773]">
		<p>HOST ITEM ENTRY
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Main entry heading:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Edition:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Place, publisher, and date of publication:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Relationship information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Physical description of source:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>Display text:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Series data for related item:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Material-specific details:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Other item identifier:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Abbreviated title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Report number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Uniform title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Standard Technical Report Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='w']">
				<li>Record control number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>International Standard Serial Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>CODEN designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>International Standard Book Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='7']">
				<li>Control subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=774]">
		<p>CONSTITUENT UNIT ENTRY
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Main entry heading:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Edition:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Qualifying information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Place, publisher, and date of publication:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Relationship information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Physical description of source:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>Display text:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Series data for related item:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Material-specific details:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Other item identifier:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Report number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Uniform title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Standard Technical Report Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='w']">
				<li>Record control number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>International Standard Serial Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>CODEN designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>International Standard Book Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='7']">
				<li>Control subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=775]">
		<p>OTHER EDITION ENTRY
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Main entry heading:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Edition:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Qualifying information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Place, publisher, and date of publication:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Language code:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Country code:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Relationship information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Physical description of source:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>Display text:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Series data for related item:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Material-specific details:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Other item identifier:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Parallel title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Report number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Uniform title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Standard Technical Report Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='w']">
				<li>Record control number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>International Standard Serial Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>CODEN designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>International Standard Book Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='7']">
				<li>Control subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=777]">
		<p>ISSUED WITH ENTRY
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Main entry heading:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Edition:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Qualifying information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Place, publisher, and date of publication:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Relationship information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Physical description of source:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>Display text:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Series data for related item:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Material-specific details:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Other item identifier:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Parallel title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Uniform title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='w']">
				<li>Record control number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>International Standard Serial Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>CODEN designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='7']">
				<li>Control subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=800]">
		<p>SERIES ADDED ENTRY--PERSONAL NAME
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field link and sequence number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Personal name:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Numeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Titles and other words associated with a name:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Dates associated with a name:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Relator term:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Date of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Attribution qualifier:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Language of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Medium of performance for music:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Arranged statement for music:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Fuller form of name:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Key for music:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Version:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Affiliation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Volume number/sequential designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='4']">
				<li>Relator code:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=810]">
		<p>SERIES ADDED ENTRY--CORPORATE NAME
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Corporate name or jurisdiction name as entry element:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Subordinate unit:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Location of meeting:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Date of meeting or treaty signing:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Relator term:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Date of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Language of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Medium of performance for music:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section/meeting:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Arranged statement for music:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Key for music:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Version:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Affiliation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Volume number/sequential designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='4']">
				<li>Relator code:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=811]">
		<p>SERIES ADDED ENTRY--MEETING NAME
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Meeting name or jurisdiction name as entry element:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Number (BK CF MP MU SE VM MX):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Location of meeting:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Date of meeting:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Subordinate unit:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Date of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Language of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section/meeting:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Name of meeting following jurisdiction name entry element:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Version:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Affiliation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Volume number/sequential designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='4']">
				<li>Relator code:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=830]">
		<p>SERIES ADDED ENTRY--UNIFORM TITLE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Uniform title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Date of treaty signing:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Date of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Language of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Medium of performance for music:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Arranged statement for music:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Key for music:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Version:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Volume number/sequential designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=840]">
		<p>SERIES ADDED ENTRY--TITLE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Volume or number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=843]">
		<p>REPRODUCTION NOTE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Type of reproduction:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Place of reproduction:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Agency responsible for reproduction:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Date of reproduction:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Physical description of reproduction:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Series statement of reproduction:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Dates of publication and/or sequential designation of issues reproduced:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Note about reproduction:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='7']">
				<li>Fixed-length data elements of reproduction:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=844]">
		<p>NAME OF UNIT
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Name of unit:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=852]">
		<p>LOCATION/CALL NUMBER
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Location:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Sublocation or collection:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Shelving location:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Address:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Coded location qualifier:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>= Qualifier type:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>= Number of units 1-9:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>= Unit type:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Non-coded location qualifier:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Classification part:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>Item part:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Shelving control number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Call number prefix:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Shelving form of title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Call number suffix:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Country code:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Piece designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Piece physical condition:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Copyright article-fee code:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Copy number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>Nonpublic note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Public note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Source of classification or shelving scheme:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Link and sequence number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=853]">
		<p>CAPTIONS AND PATTERN--BASIC BIBLIOGRAPHIC UNIT
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>First level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Second level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Third level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Fourth level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Fifth level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Sixth level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Alternative numbering scheme, first level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Alternative numbering scheme, second level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>First level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Second level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Third level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Fourth level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Alternative numbering scheme, chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Copy:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Bibliographic units per next higher level:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Numbering continuity:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='w']">
				<li>Frequency:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>Calendar change:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>Regularity pattern:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Link and sequence number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=854]">
		<p>CAPTIONS AND PATTERN--SUPPLEMENTARY MATERIAL
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>First level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Second level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Third level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Fourth level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Fifth level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Sixth level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Alternative numbering scheme, first level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Alternative numbering scheme, second level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>First level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Second level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Third level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Fourth level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Alternative numbering scheme, chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Type of supplementary material:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Copy:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Bibliographic units per next higher level:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Numbering continuity:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='w']">
				<li>Frequency:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>Calendar change:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>Regularity pattern:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Link and sequence number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=855]">
		<p>CAPTIONS AND PATTERN--INDEXES
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>First level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Second level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Third level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Fourth level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Fifth level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Sixth level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Alternative numbering scheme, first level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Alternative numbering scheme, second level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>First level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Second level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Third level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Fourth level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Alternative numbering scheme, chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Type of index:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Copy:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Bibliographic units per next higher level:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Numbering continuity:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='w']">
				<li>Frequency:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>Calendar change:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>Regularity pattern:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Link and sequence number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=856]">
		<p>ELECTRONIC LOCATION AND ACCESS
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field link and sequence number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Host name:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Access number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Compression information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Path:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Electronic name:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Uniform resource name:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Processor of request:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>Instruction:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Bits per second:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Password:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Logon:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Contact for access assistance:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Name of location of host in subfield $a:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Operating system:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Port:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Electronic format type :
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Settings:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>File size:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Terminal emulation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Uniform Resource Identifier:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Hours access method available:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='w']">
				<li>Record control number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>Nonpublic note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>Link text :
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Public note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Access method:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=863]">
		<p>ENUMERATION AND CHRONOLOGY--BASIC BIBLIOGRAPHIC UNIT
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>First level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Second level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Third level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Fourth level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Fifth level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Sixth level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Alternative numbering scheme, first level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Alternative numbering scheme, second level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>First level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Second level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Third level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Fourth level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Alternative numbering scheme, chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Converted Gregorian year:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Piece designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Piece physical condition:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Copyright article-fee code:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Copy number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='w']">
				<li>Break indicator:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>Nonpublic note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Public note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Link and sequence number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=864]">
		<p>ENUMERATION AND CHRONOLOGY--SUPPLEMENTARY MATERIAL
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>First level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Second level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Third level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Fourth level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Fifth level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Sixth level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Alternative numbering scheme, first level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Alternative numbering scheme, second level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>First level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Second level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Third level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Fourth level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Alternative numbering scheme, chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Converted Gregorian year:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Title of supplementary material:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Piece designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Piece physical condition:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Copyright article-fee code:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Copy number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='w']">
				<li>Break indicator:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>Nonpublic note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Public note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Link and sequence number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=865]">
		<p>ENUMERATION AND CHRONOLOGY--INDEXES
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>First level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Second level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Third level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Fourth level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Fifth level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Sixth level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Alternative numbering scheme, first level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Alternative numbering scheme, second level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>First level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Second level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Third level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Fourth level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Alternative numbering scheme, chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Converted Gregorian year:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Title of index:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Piece designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Piece physical condition:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Copyright article-fee code:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Copy number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='w']">
				<li>Break indicator:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>Nonpublic note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Public note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Link and sequence number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=866]">
		<p>TEXTUAL HOLDINGS--BASIC BIBLIOGRAPHIC UNIT
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Textual string:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>Nonpublic note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Public note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Link and sequence number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=867]">
		<p>TEXTUAL HOLDINGS--SUPPLEMENTARY MATERIAL
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Textual holdings:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>Nonpublic note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Public note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Link and sequence number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=868]">
		<p>TEXTUAL HOLDINGS--INDEXES
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Textual holdings:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>Nonpublic note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Public note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Link and sequence number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=870]">
		<p>VARIANT PERSONAL NAME
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Personal name:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Numeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Titles and other words associated with a name:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Dates associated with a name:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Relator term:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Date of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Tag and sequence number of the field for which 870 is a variant(R):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Language of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Fuller form of name:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Affiliation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='4']">
				<li>Relator code:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=871]">
		<p>VARIANT CORPORATE NAME
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Corporate name or jurisdiction name as entry element:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Subordinate unit:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Location of meeting:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Date of meeting or treaty signing:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Relator term:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Date of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Tag and sequence number of the field for which 871 is a variant(R):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Language of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section/meeting:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Affiliation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='4']">
				<li>Relator code:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=872]">
		<p>VARIANT CONFERENCE OR MEETING NAME
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Meeting name or jurisdiction name as entry element:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Number (BK CF MP MU SE VM MX):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Location of meeting:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Date of meeting:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Subordinate unit:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Date of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Tag and sequence number of the field for which 872 is a variant(R):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Language of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section/meeting:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Name of meeting following jurisdiction name entry element:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Affiliation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='4']">
				<li>Relator code:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=873]">
		<p>VARIANT UNIFORM TITLE HEADING
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Uniform title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Date of treaty signing:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Date of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Tag and sequence number of the field for which 873 is a variant(R):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Language of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Medium of performance for music:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Arranged statement for music:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Key for music:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Version:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title of a work:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=876]">
		<p>ITEM INFORMATION--BASIC BIBLIOGRAPHIC UNIT
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Internal item number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Invalid or cancelled internal item number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Cost:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Date acquired:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Source of acquisition:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Use restrictions:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Item status:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Temporary location:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Piece designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Invalid or cancelled piece designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Copy number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>Nonpublic note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Public note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Link and sequence number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=877]">
		<p>ITEM INFORMATION--SUPPLEMENTARY MATERIAL
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Internal item number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Invalid or cancelled internal item number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Cost:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Date acquired:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Source of acquisition:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Use restrictions:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Item status:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Temporary location:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Piece designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Invalid or cancelled piece designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Copy number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>Nonpublic note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Public note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Link and sequence number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=878]">
		<p>ITEM INFORMATION--INDEXES
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Internal item number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Invalid or cancelled internal item number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Cost:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Date acquired:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Source of acquisition:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Use restrictions:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Item status:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Temporary location:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Piece designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Invalid or cancelled piece designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Copy number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>Nonpublic note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Public note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Link and sequence number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=880]">
		<p>ALTERNATE GRAPHIC REPRESENTATION
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='w']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='0']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='1']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='4']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='5']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='7']">
				<li>Undefined; each contains blank (#):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Undefined; each contains blank (#):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='9']">
				<li>Undefined; each contains blank (#):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=886]">
		<p>FOREIGN MARC INFORMATION FIELD
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Tag of the foreign MARC field/Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Content of the foreign MARC field/Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Source of data:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='w']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='0']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='1']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='4']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='5']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='7']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='9']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
</xsl:stylesheet>
<!-- Stylus Studio meta-information - (c)1998-2002 eXcelon Corp.
<metaInformation>
<scenarios ><scenario default="no" name="Ray Charles" userelativepaths="yes" externalpreview="no" url="..\xml\MARC21slim\raycharles.xml" htmlbaseurl="" processortype="internal" commandline="" additionalpath="" additionalclasspath="" postprocessortype="none" postprocesscommandline="" postprocessadditionalpath="" postprocessgeneratedext=""/><scenario default="yes" name="s7" userelativepaths="yes" externalpreview="no" url="..\ifla\sally7.xml" htmlbaseurl="" processortype="internal" commandline="" additionalpath="" additionalclasspath="" postprocessortype="none" postprocesscommandline="" postprocessadditionalpath="" postprocessgeneratedext=""/></scenarios><MapperInfo srcSchemaPath="" srcSchemaRoot="" srcSchemaPathIsRelative="yes" srcSchemaInterpretAsXML="no" destSchemaPath="" destSchemaRoot="" destSchemaPathIsRelative="yes" destSchemaInterpretAsXML="no"/>
</metaInformation>
-->