# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2024 Raritan Inc. All rights reserved.
#
# This file was generated by IdlC from AlarmManager.idl.

use strict;

package Raritan::RPC::event::AlarmManager;

use parent qw(Raritan::RPC::RemoteObject);

use constant typeId => "event.AlarmManager:1.0.0";

sub new {
    my ($class, $agent, $rid, $typeId) = @_;
    $typeId = $typeId || Raritan::RPC::event::AlarmManager::typeId;
    return $class->SUPER::new($agent, $rid, $typeId);
}

use constant NO_ERROR => 0;

use constant ERR_UNKNOWN_ALARM_ID => 1;

use constant ERR_EXECUTING_ACTIONS => 2;

sub acknowledgeAlarm($$) {
    my ($self, $alarmId) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'alarmId'} = "$alarmId";
    my $rsp = $agent->json_rpc($self->{'rid'}, 'acknowledgeAlarm', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::event::AlarmManager::Alarm;

sub listAlarms($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'listAlarms', $args);
    my $_ret_;
    $_ret_ = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        $_ret_->[$i0] = Raritan::RPC::event::AlarmManager::Alarm::decode($agent, $rsp->{'_ret_'}->[$i0]);
    }
    return $_ret_;
}

Raritan::RPC::Registry::registerProxyClass('event.AlarmManager', 1, 0, 0, 'Raritan::RPC::event::AlarmManager');
1;
