# Announce: Rakudo Perl 6 compiler, Release #106 (2016.12)

On behalf of the Rakudo development team, I’m very happy to announce the
December 2016 release of Rakudo Perl 6 #106. Rakudo is an implementation of
Perl 6 on the Moar Virtual Machine[^1].

This release implements the 6.c version of the Perl 6 specifications.
It includes bugfixes and optimizations on top of
the 2015.12 release of Rakudo, but no new features.

Upcoming releases in 2017 will include new functionality that is not
part of the 6.c specification, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of the
6.c specification will continue to work unchanged. There may be incremental
spec releases this year as well.

The tarball for this release is available from <http://rakudo.org/downloads/rakudo/>.

Please note: This announcement is not for the Rakudo Star
distribution[^2] --- it’s announcing a new release of the compiler
only. For the latest Rakudo Star release, see
<http://rakudo.org/downloads/star/>.

The changes in this release are outlined below:

New in 2016.12:
 + Fixes
    + Fixed inability to autocurry superscript exponents properly [c35d562]
    + Fixed Match.prematch and Match.postmatch for zero-width matches [c04b8b5]
    + Fixed Match objects being erroneously treated as value types [7f26e8b]
    + Made U+2212 minus work in places it didn't [cb9df2b][01775b7][6cd2144]
    + prefix:<~> now calls .Str on Str types (helps with allomorphs) [e0a415f]
    + Fixed errors in `$*ARGFILES.lines` limit counter [bd42363]
    + Fixed bug with add history for Readline module in REPL [f544e4c]
    + sum and [+] metaop now correctly work on Junctions [8d04bec]
    + Fixed various scoping bugs with NEXT/LAST/QUIT [6bb8823]
    + Fixed issues in QUIT handlers running asynchronously [c027e6a]
    + Fixed occassional hangs in Proc::Async [e4d78c6]
    + Fixed operations still running after supply deactivation [f928a20]
    + Fixed Iterator.flat occasionally skipping inner iterables [61a18c0]
    + Fixed slurp not propagating :bin and :enc args on `$*ARGFILES` [15f51a5]
    + Fixed negative zero handling in many places
        [f1263ab][e2587cd][a9654c0][085145f]
    + Synthetics in numbers in colonpairs in :42foo format now throw [4663d43]
    + Fixed hang in .subst with no arguments [0a874fb]
    + Fixed sleep() with huge values failing to sleep
        [c797d3f][7c5ea31][2f72fa0]
    + Fixed attributive binding not looking outward for `self` [843a6be]
    + Fixed sprintf($format) without args issuing spurious warnings [35183f3]
    + Fixed infix:<===> failing when both sides are allomorphs [4a59ab4]
    + Fixed data race in Supply.interval [47ffdea]
    + Fixed data races in supply/whenever [33f7456]
    + Fixed memory corruption in Proc::Async [74eb6b9]
    + Fixed handling of time resolutions below 1ms in Supply.interval [c38f1ad]
    + Fixed issues with `-Inf` being a single term [ae614f9]
    + Fixed Signature.gist stripping sigils from anon typeless scalars [219f527]
    + Made permutations/combinations/grep die instead
        of fail()ing [ab3a59c][bc13bb5]
    + Fixed spurious warnings on .trans with regex pair complements [2e1b82c]
    + Fixed premature frees in async sockets when errors occur [b2ac4e4]
    + Fixed handling of superscript powers larger than int [0428b79]
    + Fixed Proc::Async sending empty string to taps on program exit [7532297]
    + Fixed wrong results for .first on Numerics [8cb3e1b]
    + Fixed matcher-less .first not respecting its adverbs [ababb24]
    + Fixed `sink` statement prefix failing to explode Failures [345f6a7]
    + Fixed regression in S:g/// not returning original string [5476d60]
    + Reverted .match/.comb to return empty List instead of Empty when failing
        to match [5476d60]
    + Fixed Mu.clone incorrectly marking all attributes as initialized [9a161fa]
    + Fixed cloned Baggy having an undefined .WHICH [9a161fa]
    + Fixed smartmatching against UInt type object [f9d34a9]
    + Fixed some Date constructors accepting invalid dates [aa27d5c]
    + Fixed .rotor on empty list returning an internal iterator object [5558710]
    + Fixed unimatch to check canonical short/alternate unicode props [b456471]
    + Fixed uniprop to return correct values for na, uc, tc, lc properties
        [2a8ec40]
    + Fixed uniprop for 'Numeric_Value' not returning a numeric value [9ff5b7e]
    + Fixed crash with Rat Ranges constructed with Range ops [1d46004]
    + Fixed crash with tapping supplies supplied by thunked block [a980eb1]
    + Fixed .perl on parametarized Hashes with no items in them [003e654]
    + Fixed .perl for itemized Slips [8eef234]
    + Fixed chained `andthen`/`orelse` operators returning internals [287af6a]
    + Fixed ThreadPoolScheduler.cue not applying delays to all cues [b286048]
    + Fixed control exception propagation when thrown from within statements
        handled by `without`, `with`, `andthen`, or `noandthen` [9a3c350]
    + Fixed Rand.rand generating value equal to excluded end point [334d134]
    + Fixed `last` not working inside .grep's block [7021861][f775474]
    + Fixed .head not always returning a .Seq [69d808f]
    + Various fixes and improvements in error reporting
 + Additions:
    + Bare \b, \B, and \K in regexes now throw [08589d3][ee14067]
    + Added SQL as an output option for --profile-filename [f20b8b6]
    + Implemented native str Arrays [014d4cf][6d726f8]
    + sub MAIN now allows Enums as type constraints [546dbd9]
    + Count in .pick/pickpairs/grab/grabpairs can now be a Callable [e9487d6]
    + REPL with Readline module now loads `inputrc` files [573ed59]
    + REPL with Readline module now saves history [9043f58]
    + perl6 --doc=Text now shows signature parameter pod [6ea6563]
    + Generated sub MAIN usage message now shows original program name [b597b7c]
    + Added arity-1 infix:<~> for Blobs [77e9d4b]
    + Added IO::Handle.printf [8774f24][3c4ac3c]
    + Added ability to negate all numeric literals in signatures [5baa064]
    + Added .reverse/.rotate/.sum to shaped 1-dimmed arrays [a2ede36][4f4737d]
    + Added Mu.emit [4e76827]
    + Added --with-nqp Configure option for having NQP in
        a different prefix [6f6e6db]
    + Added .gist, .perl, and .Str to BOOTSTRAPATTR [3dd2916]
    + Made .sum nodal [4fd6e94]
    + Implemented uniprops [f55ff82][0328422][05db996]
    + Added 5 new sets of matching brackets for available delimiters [8965145]
 + Removals:
    + Removed X::Syntax::Number::InvalidCharacter exception [a8ff3b9]
 + Efficiency:
    + Made indirect type lookup 3x as fast [939d273]
    + Made shaped(int|num|str)array.AT-POS at least 15% faster [bfe89a5]
    + Made shaped(int|num|str)array.ASSIGN-POS at least 10% faster [ecc202e]
    + Made shaped(int|num|str)array.EXISTS-POS at least 20% faster [bbbb2b6]
    + Made 1-dimmed native arrays at least 3x faster [4a711bc]
    + Made native shaped array creation about 1.5x faster [1b840f1]
    + Made native 1-dimmed array init at least 11x faster [b6de5e8]
    + Made native 1-dimmed array copying at least 25x faster [b6de5e8]
    + Made use of native 2-dimmed arrays 2.5x–4x faster [172898e]
    + Made use of native 3-dimmed arrays 2.5x–4x faster [64343d7]
    + Made copying 1+ dimmed native arrays up to 9x faster [e0c0ae5][331c2e2]
    + Made copying intX[2;2] to intY[2;2] native array just as fast as
        copying intX[2;2] to intX[2;2] [79090b2]
    + Made native shaped array initialization 4x–6x faster [d704820]
    + Made iteration of 1-dimmed native arrays 17x faster [947422b]
    + Made iteration of >1 dimmed native arrays 11x faster [3e93ddd]
    + Made .(anti)pairs for native shaped arrays 7x faster [39261e7][471cea2]
    + Made .kv for native shaped arrays 16x faster [965fa4d][c1a3a3c]
    + Made native array.reverse|rotate about 20x faster [0ee6bc0]
    + Made @a[2;2] about 40% faster [b9e2ffa]
    + Optimized Int->int coercion [b2ac4e4]
    + Made infix:<..> on Nums 13x faster [a8ba26b]
    + Made uniprop with the default lookup 5x faster and other lookups 15% faster. [474ea33]
    + Made print, say and note 25% faster to stderr and stdout [e9ce28a]


The following people contributed to this release:

Zoffix Znet, Pawel Murias, Elizabeth Mattijsen, Wenzel P. P. Peppmeyer, 
Will "Coke" Coleda, Samantha McVey, Altai-man, Jonathan Worthington, 
Stefan Seifert, Daniel Green, Christian Bartolomäus, ZzZombo, 
Aleks-Daniel Jakimenko-Aleksejev, Jan-Olof Hendig, Moritz Lenz, Tom Browder, 
Itsuki Toyota, Larry Wall, Bahtiar `kalkin-` Gadimov, seatek, Pepe Schwarz, 
Paul Cochrane, Brian Gernhardt, Ronald Schmidt, Daniel Mita, 0racle, 
Timo Paulssen, Jonathan Stowe, Fernando Correa de Oliveira, Steve Mynott, 
Douglas L. Schrag, Jonathan Scott Duff, Donald Hunter, Siavash Askari Nasr, 
Paweł Murias, Breno G. de Oliveira, bazzaar, cygx, francois, Lucas Buchala

If you would like to contribute or find out more information, visit
<http://perl6.org>, <http://rakudo.org/how-to-help>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #perl6 on freenode.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Perl 6 development: <https://donate.perlfoundation.org/>
(put "Perl 6 Core Development Fund" in the 'Purpose' text field)

The next release of Rakudo (#107), is tentatively scheduled for 2017-01-21.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback -- get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <http://moarvm.org/>

[^2]: What’s the difference between the Rakudo compiler and the Rakudo
Star distribution?

The Rakudo compiler is a compiler for the Perl 6 language.
Not much more.

The Rakudo Star distribution is the Rakudo compiler plus a selection
of useful Perl 6 modules, a module installer, the most recent
incarnation of the “Using Perl 6” book, and other software that can
be used with the Rakudo compiler to enhance its utility.

