% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paths.R
\name{existing_files}
\alias{existing_files}
\title{Find file paths that exist}
\usage{
existing_files(x, first = FALSE)
}
\arguments{
\item{x}{A vector of file paths.}

\item{first}{Whether to return the first existing path. If \code{TRUE} and no
specified files exist, it will signal an error.}
}
\value{
A vector of existing file paths.
}
\description{
This is a shorthand of \code{x[file.exists(x)]}, and optionally returns the
first existing file path.
}
\examples{
xfun::existing_files(c("foo.txt", system.file("DESCRIPTION", package = "xfun")))
}
