% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dwpt_sim.R
\name{find.adaptive.basis}
\alias{find.adaptive.basis}
\title{Determine an Orthonormal Basis for the Discrete Wavelet Packet Transform}
\usage{
find.adaptive.basis(wf, J, fG, eps)
}
\arguments{
\item{wf}{Character string; name of the wavelet filter.}

\item{J}{Depth of the discrete wavelet packet transform.}

\item{fG}{Gegenbauer frequency.}

\item{eps}{Threshold for the squared gain function.}
}
\value{
Boolean vector describing the orthonormal basis for the DWPT.
}
\description{
Subroutine for use in simulating seasonal persistent processes using the
discrete wavelet packet transform.
}
\details{
The squared gain functions for a Daubechies (extremal phase or least
asymmetric) wavelet family are used in a filter cascade to compute the value
of the squared gain function for the wavelet packet filter at the
Gengenbauer frequency.  This is done for all nodes of the wavelet packet
table.

The idea behind this subroutine is to approximate the relationship between
the discrete wavelet transform and long-memory processes, where the squared
gain function is zero at frequency zero for all levels of the DWT.
}
\seealso{
Used in \code{\link{dwpt.sim}}.
}
\author{
B. Whitcher
}
\keyword{ts}
