% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view.R
\name{str_view}
\alias{str_view}
\alias{str_view_all}
\title{View HTML rendering of regular expression match.}
\usage{
str_view(string, pattern, match = NA)

str_view_all(string, pattern, match = NA)
}
\arguments{
\item{string}{Input vector. Either a character vector, or something
coercible to one.}

\item{pattern}{Pattern to look for.

The default interpretation is a regular expression, as described
in \link[stringi:stringi-search-regex]{stringi::stringi-search-regex}. Control options with
\code{\link[=regex]{regex()}}.

Match a fixed string (i.e. by comparing only bytes), using
\code{\link[=fixed]{fixed()}}. This is fast, but approximate. Generally,
for matching human text, you'll want \code{\link[=coll]{coll()}} which
respects character matching rules for the specified locale.

Match character, word, line and sentence boundaries with
\code{\link[=boundary]{boundary()}}. An empty pattern, "", is equivalent to
\code{boundary("character")}.}

\item{match}{If \code{TRUE}, shows only strings that match the pattern.
If \code{FALSE}, shows only the strings that don't match the pattern.
Otherwise (the default, \code{NA}) displays both matches and non-matches.}
}
\description{
\code{str_view} shows the first match; \code{str_view_all} shows all
the matches.
}
\examples{
str_view(c("abc", "def", "fgh"), "[aeiou]")
str_view(c("abc", "def", "fgh"), "^")
str_view(c("abc", "def", "fgh"), "..")

# Show all matches with str_view_all
str_view_all(c("abc", "def", "fgh"), "d|e")

# Use match to control what is shown
str_view(c("abc", "def", "fgh"), "d|e")
str_view(c("abc", "def", "fgh"), "d|e", match = TRUE)
str_view(c("abc", "def", "fgh"), "d|e", match = FALSE)
}
