% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/colour-mapping.r
\name{colour_ramp}
\alias{colour_ramp}
\title{Fast color interpolation}
\usage{
colour_ramp(colors, na.color = NA, alpha = FALSE)
}
\arguments{
\item{colors}{Colors to interpolate; must be a valid argument to
\code{\link[grDevices]{col2rgb}}. This can be a character vector of
\code{"#RRGGBB"} or  \code{"#RRGGBBAA"}, color names from
\code{\link[grDevices]{colors}}, or a positive integer that indexes into
\code{\link[grDevices]{palette}()}.}

\item{na.color}{The color to map to \code{NA} values (for example,
\code{"#606060"} for dark grey, or \code{"#00000000"} for transparent) and
values outside of [0,1]. Can itself by \code{NA}, which will simply cause
an \code{NA} to be inserted into the output.}

\item{alpha}{Whether to include alpha channels in interpolation; otherwise,
  any alpha information will be discarded. If \code{TRUE} then the returned
  function will provide colors in \code{"#RRGGBBAA"} format instead of
  \code{"#RRGGBB"}.}
}
\value{
A function that takes a numeric vector and returns a character vector
  of the same length with RGB or RGBA hex colors.
}
\description{
Returns a function that maps the interval [0,1] to a set of colors.
Interpolation is performed in the CIELAB color space. Similar to
\code{\link[grDevices]{colorRamp}(space = 'Lab')}, but hundreds of
times faster, and provides results in \code{"#RRGGBB"} (or
\code{"#RRGGBBAA"}) character form instead of RGB color matrices.
}
\seealso{
\link[grDevices]{colorRamp}
}

