% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/alply.r
\name{alply}
\alias{alply}
\title{Split array, apply function, and return results in a list.}
\usage{
alply(.data, .margins, .fun = NULL, ..., .expand = TRUE,
  .progress = "none", .inform = FALSE, .parallel = FALSE,
  .paropts = NULL, .dims = FALSE)
}
\arguments{
\item{.data}{matrix, array or data frame to be processed}

\item{.margins}{a vector giving the subscripts to split up \code{data} by.
1 splits up by rows, 2 by columns and c(1,2) by rows and columns, and so
on for higher dimensions}

\item{.fun}{function to apply to each piece}

\item{...}{other arguments passed on to \code{.fun}}

\item{.expand}{if \code{.data} is a data frame, should output be 1d (expand
 = FALSE), with an element for each row; or nd (expand = TRUE), with a
dimension for each variable.}

\item{.progress}{name of the progress bar to use, see
\code{\link{create_progress_bar}}}

\item{.inform}{produce informative error messages?  This is turned off
by default because it substantially slows processing speed, but is very
useful for debugging}

\item{.parallel}{if \code{TRUE}, apply function in parallel, using parallel
backend provided by foreach}

\item{.paropts}{a list of additional options passed into
the \code{\link[foreach]{foreach}} function when parallel computation
is enabled.  This is important if (for example) your code relies on
external data or packages: use the \code{.export} and \code{.packages}
arguments to supply them so that all cluster nodes have the correct
environment set up for computing.}

\item{.dims}{if \code{TRUE}, copy over dimensions and names from input.}
}
\value{
list of results
}
\description{
For each slice of an array, apply function then combine results into a
list.
}
\details{
The list will have "dims" and "dimnames" corresponding to the
margins given. For instance \code{alply(x, c(3,2), ...)} where
\code{x} has dims \code{c(4,3,2)} will give a result with dims
\code{c(2,3)}.

\code{alply} is somewhat similar to \code{\link{apply}} for cases
where the results are not atomic.
}
\section{Input}{
 This function splits matrices, arrays and data frames by
  dimensions
}

\section{Output}{
 If there are no results, then this function will return
  a list of length 0 (\code{list()}).
}
\examples{
alply(ozone, 3, quantile)
alply(ozone, 3, function(x) table(round(x)))
}
\references{
Hadley Wickham (2011). The Split-Apply-Combine Strategy
  for Data Analysis. Journal of Statistical Software, 40(1), 1-29.
  \url{http://www.jstatsoft.org/v40/i01/}.
}
\seealso{
Other array input: \code{\link{a_ply}};
  \code{\link{aaply}}; \code{\link{adply}}

Other list output: \code{\link{dlply}};
  \code{\link{llply}}; \code{\link{mlply}}
}
\keyword{manip}

