% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/officer.R
\docType{package}
\name{officer}
\alias{officer-package}
\alias{officer}
\title{Manipulate Microsoft Word and PowerPoint Documents with 'officer'}
\description{
The officer package facilitates access to and manipulation of
'Microsoft Word' and 'Microsoft PowerPoint' documents from R.
It also supports the writing of 'RTF' documents.

Examples of usage are:
\itemize{
\item Create Word documents with tables, titles, TOC and graphics
\item Importation of Word and PowerPoint files into data objects
\item Write updated content back to a PowerPoint presentation
\item Clinical reporting automation
\item Production of reports from a shiny application
}

To start with officer, read about \code{\link[=read_docx]{read_docx()}}, \code{\link[=read_pptx]{read_pptx()}}
or \code{\link[=rtf_doc]{rtf_doc()}}.

The package is also providing several objects that can be printed
in 'R Markdown' documents for advanced Word or PowerPoint
reporting as \code{\link[=run_autonum]{run_autonum()}} and \code{\link[=block_caption]{block_caption()}}.
}
\seealso{
The user documentation: \url{https://ardata-fr.github.io/officeverse/} and
manuals \url{https://davidgohel.github.io/officer/}
}
\author{
\strong{Maintainer}: David Gohel \email{david.gohel@ardata.fr}

Authors:
\itemize{
  \item Stefan Moog \email{moogs@gmx.de}
}

Other contributors:
\itemize{
  \item ArData [copyright holder]
  \item Frank Hangler \email{frank@plotandscatter.com} (function body_replace_all_text) [contributor]
  \item Liz Sander \email{lsander@civisanalytics.com} (several documentation fixes) [contributor]
  \item Anton Victorson \email{anton@victorson.se} (fixes xml structures) [contributor]
  \item Jon Calder \email{jonmcalder@gmail.com} (update vignettes) [contributor]
  \item John Harrold \email{john.m.harrold@gmail.com} (function annotate_base) [contributor]
  \item John Muschelli \email{muschellij2@gmail.com} (google doc compatibility) [contributor]
  \item Bill Denney \email{wdenney@humanpredictions.com} (\href{https://orcid.org/0000-0002-5759-428X}{ORCID}) (function as.matrix.rpptx) [contributor]
  \item Nikolai Beck \email{beck.nikolai@gmail.com} (set speaker notes for .pptx documents) [contributor]
  \item Greg Leleu \email{gregoire.leleu@gmail.com} (fields functionality in ppt) [contributor]
  \item Hongyuan Jia \email{hongyuanjia@cqust.edu.cn} (\href{https://orcid.org/0000-0002-0075-8183}{ORCID}) [contributor]
}

}
