% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/casewise.R
\name{casewise}
\alias{casewise}
\title{Estimates the casewise concordance based on Concordance and marginal estimate using prodlim but no testing}
\usage{
casewise(conc, marg, cause.marg)
}
\arguments{
\item{conc}{Concordance}

\item{marg}{Marginal estimate}

\item{cause.marg}{specififes which cause that should be used for marginal cif based on prodlim}
}
\description{
.. content for description (no empty lines) ..
}
\examples{
\donttest{ ## Reduce Ex.Timings
library(prodlim)
data(prt);
prt <- force.same.cens(prt,cause="status")

### marginal cumulative incidence of prostate cancer##' 
outm <- prodlim(Hist(time,status)~+1,data=prt)

times <- 60:100
cifmz <- predict(outm,cause=2,time=times,newdata=data.frame(zyg="MZ")) ## cause is 2 (second cause) 
cifdz <- predict(outm,cause=2,time=times,newdata=data.frame(zyg="DZ"))

### concordance for MZ and DZ twins
cc <- bicomprisk(Event(time,status)~strata(zyg)+id(id),data=prt,cause=c(2,2),prodlim=TRUE)
cdz <- cc$model$"DZ"
cmz <- cc$model$"MZ"

cdz <- casewise(cdz,outm,cause.marg=2) 
cmz <- casewise(cmz,outm,cause.marg=2)

plot(cmz,ci=NULL,ylim=c(0,0.5),xlim=c(60,100),legend=TRUE,col=c(3,2,1))
par(new=TRUE)
plot(cdz,ci=NULL,ylim=c(0,0.5),xlim=c(60,100),legend=TRUE)
summary(cdz)
summary(cmz)
}
}
\author{
Thomas Scheike
}
