% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/when.R
\name{when}
\alias{when}
\title{When}
\usage{
when(object, tz = "GMT", origin = "1970-01-01", usetz = TRUE)
}
\arguments{
\item{object}{the \code{object} to extract the time slot from.}

\item{tz}{time zone specification to be used for the conversion,
    \emph{if one is required}.  System-specific (see \link[base]{time zones}),
    but \code{""} is the current time zone, and \code{"GMT"} is UTC
    (Universal Time, Coordinated).  Invalid values are most commonly
    treated as UTC, on some platforms with a warning.}

\item{origin}{a date-time object, or something which can be coerced by
    \code{as.POSIXct(tz = "GMT")} to such an object.}

\item{usetz}{logical.  Should the time zone abbreviation be appended
    to the output?  This is used in printing times, and more reliable
    than using \code{"\%Z"}.}
}
\value{
A \code{character} vector of length one.
}
\description{
Help method to extract the time as a character string from a
git_commit, git_signature, git_tag and git_time object.
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Create a first user and commit a file
config(repo, user.name = "Alice", user.email = "alice@example.org")
writeLines("Hello world!", file.path(path, "example.txt"))
add(repo, "example.txt")
commit(repo, "First commit message")

## Create tag
tag(repo, "Tagname", "Tag message")

when(commits(repo)[[1]])
when(tags(repo)[[1]])
when(tags(repo)[[1]], tz = Sys.timezone())
}
}
\seealso{
\code{\link{git_time}}
}
