% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-rows.R
\name{rownames_as_column}
\alias{rownames_as_column}
\alias{column_as_rownames}
\alias{rowid_as_column}
\title{Tools for working with row names or row ids}
\usage{
rownames_as_column(x, var = "rowname")

column_as_rownames(x, var = "rowname")

rowid_as_column(x, var = "rowid")
}
\arguments{
\item{x}{A data frame.}

\item{var}{Name of column to use for row names/ids. For \code{column_as_rownames()},
this argument can be the variable name or the column number. For
\code{rownames_as_column()} and \code{rowid_as_column()}, the column name must not
already exist in the data.}
}
\value{
A data frame.
}
\description{
Tools for working with row names or row ids
}
\details{
These are similar to \code{tibble}'s functions \code{column_to_rownames()},
\code{rownames_to_column()} and \code{rowid_to_column()}. Note that the behavior of
\code{rowid_as_column()} is different for grouped dataframe: instead of making
the rowid unique across the full dataframe, it creates rowid per group.
Therefore, there can be several rows with the same rowid if they belong to
different groups.

If you are familiar with \code{dplyr}, this is similar to doing the following:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{data |>
  group_by(grp) |>
  mutate(id = row_number()) |>
  ungroup()
}\if{html}{\out{</div>}}
}
\examples{
# Convert between row names and column --------------------------------
test <- rownames_as_column(mtcars, var = "car")
test
head(column_as_rownames(test, var = "car"))

test_data <- head(iris)

rowid_as_column(test_data)
rowid_as_column(test_data, var = "my_id")
}
