% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gregorian-year-day.R
\name{year-day-getters}
\alias{year-day-getters}
\alias{get_year.clock_year_day}
\alias{get_day.clock_year_day}
\alias{get_hour.clock_year_day}
\alias{get_minute.clock_year_day}
\alias{get_second.clock_year_day}
\alias{get_millisecond.clock_year_day}
\alias{get_microsecond.clock_year_day}
\alias{get_nanosecond.clock_year_day}
\title{Getters: year-day}
\usage{
\method{get_year}{clock_year_day}(x)

\method{get_day}{clock_year_day}(x)

\method{get_hour}{clock_year_day}(x)

\method{get_minute}{clock_year_day}(x)

\method{get_second}{clock_year_day}(x)

\method{get_millisecond}{clock_year_day}(x)

\method{get_microsecond}{clock_year_day}(x)

\method{get_nanosecond}{clock_year_day}(x)
}
\arguments{
\item{x}{\verb{[clock_year_day]}

A year-day to get the component from.}
}
\value{
The component.
}
\description{
These are year-day methods for the \link[=clock-getters]{getter generics}.
\itemize{
\item \code{get_year()} returns the Gregorian year.
\item \code{get_day()} returns the day of the year.
\item There are sub-daily getters for extracting more precise components.
}
}
\examples{
x <- year_day(2019, 101:105, 1, 20, 30)

get_day(x)
get_second(x)

# Cannot extract more precise components
y <- year_day(2019, 1)
try(get_hour(y))

# Cannot extract components that don't exist for this calendar
try(get_quarter(x))
}
