% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_weights.R
\name{posterior_average.brmsfit}
\alias{posterior_average.brmsfit}
\alias{posterior_average}
\title{Posterior samples of parameters averaged across models}
\usage{
\method{posterior_average}{brmsfit}(
  x,
  ...,
  pars = NULL,
  weights = "stacking",
  nsamples = NULL,
  missing = NULL,
  model_names = NULL,
  control = list(),
  seed = NULL
)

posterior_average(x, ...)
}
\arguments{
\item{x}{A \code{brmsfit} object.}

\item{...}{More \code{brmsfit} objects or further arguments
passed to the underlying post-processing functions.
In particular, see \code{\link{extract_draws}} for further
supported arguments.}

\item{pars}{Names of parameters for which to average across models.
Only those parameters can be averaged that appear in every model.
Defaults to all overlapping parameters.}

\item{weights}{Name of the criterion to compute weights from. Should be one
of \code{"loo"}, \code{"waic"}, \code{"kfold"}, \code{"stacking"} (current
default), or \code{"bma"}, \code{"pseudobma"}, For the former three
options, Akaike weights will be computed based on the information criterion
values returned by the respective methods. For \code{"stacking"} and
\code{"pseudobma"} method \code{\link{loo_model_weights}} will be used to
obtain weights. For \code{"bma"}, method \code{\link{post_prob}} will be
used to compute Bayesian model averaging weights based on log marginal
likelihood values (make sure to specify reasonable priors in this case).
Some some method, \code{weights} may also be be a numeric vector of
pre-specified weights.}

\item{nsamples}{Total number of posterior samples to use.}

\item{missing}{An optional numeric value or a named list of numeric values 
to use if a model does not contain a parameter for which posterior samples 
should be averaged. Defaults to \code{NULL}, in which case only those
parameters can be averaged that are present in all of the models.}

\item{model_names}{If \code{NULL} (the default) will use model names 
derived from deparsing the call. Otherwise will use the passed 
values as model names.}

\item{control}{Optional \code{list} of further arguments 
passed to the function specified in \code{weights}.}

\item{seed}{A single numeric value passed to \code{\link{set.seed}}
to make results reproducible.}
}
\value{
A \code{data.frame} of posterior samples. Samples are rows
  and parameters are columns.
}
\description{
Extract posterior samples of parameters averaged across models.
Weighting can be done in various ways, for instance using
Akaike weights based on information criteria or 
marginal likelihoods.
}
\details{
Weights are computed with the \code{\link{model_weights}} method.
}
\examples{
\dontrun{
# model with 'treat' as predictor
fit1 <- brm(rating ~ treat + period + carry, data = inhaler)
summary(fit1)

# model without 'treat' as predictor
fit2 <- brm(rating ~ period + carry, data = inhaler)
summary(fit2)

# compute model-averaged posteriors of overlapping parameters
posterior_average(fit1, fit2, weights = "waic")
}

}
\seealso{
\code{\link{model_weights}}, \code{\link{pp_average}}
}
