% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesplot-ggplot-themes.R
\name{bayesplot_theme_get}
\alias{bayesplot_theme_get}
\alias{bayesplot_theme_set}
\alias{bayesplot_theme_update}
\alias{bayesplot_theme_replace}
\title{Get, set, and modify the active \strong{bayesplot} theme}
\usage{
bayesplot_theme_get()

bayesplot_theme_set(new = theme_default())

bayesplot_theme_update(...)

bayesplot_theme_replace(...)
}
\arguments{
\item{new}{The new theme (list of theme elements) to use. This is analogous
to the \code{new} argument to \code{\link[ggplot2:get_theme]{ggplot2::theme_set()}}.}

\item{...}{A named list of theme settings.}
}
\value{
\code{bayesplot_theme_get()} returns the current theme. The other three
functions (set, update, replace) invisibly return the \emph{previous} theme
so it can be saved and easily restored later. This is the same behavior as
the \strong{ggplot2} versions of these functions.
}
\description{
These functions are the \strong{bayesplot} equivalent to
\strong{ggplot2}'s \code{\link[ggplot2:get_theme]{ggplot2::theme_set()}} and friends. They set, get, and update
the active theme but only apply them to \code{bayesplots}. The current/active
theme is automatically applied to every \code{bayesplot} you draw.

Use \code{bayesplot_theme_get()} to get the current \strong{bayesplot} theme and
\code{bayesplot_theme_set()} to set a new theme. \code{bayesplot_theme_update()} and
\code{bayesplot_theme_replace()} are shorthands for changing individual elements.
}
\details{
\code{bayesplot_theme_set()} and friends only apply to \code{bayesplots}.
However, \code{\link[ggplot2:get_theme]{ggplot2::theme_set()}} can also be used to change the
\strong{bayesplot} theme. Currently, setting a theme with \code{ggplot2::theme_set()}
(other than the \strong{ggplot2} default \code{\link[ggplot2:ggtheme]{ggplot2::theme_grey()}}) will override
the \strong{bayesplot} theme.
}
\examples{
library(ggplot2)

# plot using the current value of bayesplot_theme_get()
# (the default is bayesplot::theme_default())
x <- example_mcmc_draws()
mcmc_hist(x)

# change the bayesplot theme to theme_minimal and save the old theme
old <- bayesplot_theme_set(theme_minimal())
mcmc_hist(x)

# change back to the previous theme
bayesplot_theme_set(old)
mcmc_hist(x)

# change the default font size and family for bayesplots
bayesplot_theme_update(text = element_text(size = 16, family = "sans"))
mcmc_hist(x)

# change back to the default
bayesplot_theme_set() # same as bayesplot_theme_set(theme_default())
mcmc_hist(x)

# updating theme elements
color_scheme_set("brightblue")
bayesplot_theme_set(theme_dark())
mcmc_hist(x)

bayesplot_theme_update(panel.background = element_rect(fill = "black"))
mcmc_hist(x)

# to get the same plot without updating the theme we could also have
# used the bayeplot convenience function panel_bg()
bayesplot_theme_set(theme_dark())
mcmc_hist(x) + panel_bg(fill = "black")

# reset
bayesplot_theme_set()

}
\seealso{
\code{\link[=theme_default]{theme_default()}} for the default \strong{bayesplot} theme.

\link{bayesplot-helpers} for a variety of convenience functions,
many of which provide shortcuts for tweaking theme elements after creating
a plot.

\link{bayesplot-colors} to set or view the color scheme used
for plotting.
}
