% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_models.R
\name{compare_elbo}
\alias{compare_elbo}
\title{Compare different trained \code{\link{MOFA}} objects in terms of the final value of the ELBO statistics and number of inferred factors}
\usage{
compare_elbo(models, log = FALSE, return_data = FALSE)
}
\arguments{
\item{models}{a list containing \code{\link{MOFA}} objects.}

\item{log}{logical indicating whether to plot the log of the ELBO.}

\item{return_data}{logical indicating whether to return a data.frame with the ELBO values per model}
}
\value{
A \code{\link{ggplot}} object or the underlying data.frame if return_data is TRUE
}
\description{
Different objects of \code{\link{MOFA}} are compared in terms of the final value of the ELBO statistics.
For model selection the model with the highest ELBO value is selected.
}
\examples{
# Using an existing trained model on simulated data
file <- system.file("extdata", "model.hdf5", package = "MOFA2")
model1 <- load_model(file)
model2 <- load_model(file)

# Compare ELBO between models
\dontrun{compare_elbo(list(model1,model2))}
}
