'''OpenGL extension NV.vertex_buffer_unified_memory

This module customises the behaviour of the 
OpenGL.raw.GL.NV.vertex_buffer_unified_memory to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension provides a mechanism to specify vertex attrib and
	element array locations using GPU addresses.
	
	Binding vertex buffers is one of the most frequent and expensive
	operations in many GL applications, due to the cost of chasing 
	pointers and binding objects described in the Overview of 
	NV_shader_buffer_load. The intent of this extension is to enable a 
	way for the application to specify vertex attrib state that alleviates
	the overhead of object binds and driver memory management.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/vertex_buffer_unified_memory.txt
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL.NV.vertex_buffer_unified_memory import *
### END AUTOGENERATED SECTION