#-*- coding: utf-8 -*-


licence="""
    file dozz.py: part of the package pyacidobasic version %s:

    Copyright (C) 2010 Georges Khaznadar <georgesk@ofset.org>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""

from xml.dom.minidom import parseString
from codecs import open
import string
import re

def sanitizeXML(s, firstline=1):
    """
    Assainit une chaîne XML en supprimant les caractères interdits
    dans le marquage XML.
    @param s du code XML incorrect
    @param firstline la première ligne où le code peut être incorrect
    @return du code XML assaini
    """
    invalid=u' !"#%\'()*+,-.:;=?@[\]^_`{|}~'
    valid  ="_"*len(invalid)
    tr = dict((ord(char), u'_') for char in invalid)
    #tr=string.maketrans(invalid,valid)###
    
    s=map(lambda l: l.strip(), s.split("\n"))
    for i in range(firstline, len(s)):
        if s[i][0]=="<":
            s[i]=s[i].translate(tr)
    return u" ".join(s)

def dozParse(fileName="/usr/share/dozzaqueux/base.equ"):
    """
    Lit un fichier chimique et renvoie un objet DOM
    @param fileName le nom du fichier à lire
    @return un objet DOM
    """
    dozzzSource=open(fileName,"r","utf-8").read()
    dozzzSource='<?xml version="1.0" encoding="ISO-8859-1"?> <dozzz>' + dozzzSource + "</dozzz>"
    dozzzSource=sanitizeXML(dozzzSource)
    return parseString(dozzzSource.encode("utf-8"))

def doz2html(s):
    """
    Traduit la notation d'identifiants Dozzzaqueux en code HTML
    @param s un identifiant Dozzzaqueux
    @return sa traduction HTML
    """
    s=s.strip()
    m=re.match("(.*)\[(.*)\]", s)
    if m:
        formule=m.group(1)
        charge=m.group(2)
    else:
        formule=s
        charge=""
    formule=re.sub("([0-9]+)", "<sub>\\1</sub>", formule)
    if charge:
        charge="<sup>"+charge+"</sup>"
    return formule+charge
    
    

def elementsAvecConductivite(doz):
    """
    Renvoie un dictionnaire d'éléments qui ont une conductivité renseignée
    @param doz un objet DOM
    @return un dictionnaire
    """
    result={}
    l=doz.getElementsByTagName("Element")
    for e in l:
        c=e.getElementsByTagName("Conductivite")
        if c:
            c=float( c[0].firstChild.data)
            if c != 0.0:
                identifiant=e.getElementsByTagName("Identifiant")[0].firstChild.data.encode("latin-1") ### quelque chose a dû être cassé avant ça, peut-être un bug dans parseString ?
                result[doz2html(identifiant)]=c
    return result

if __name__=="__main__":
    doz = dozParse()
    ec = elementsAvecConductivite(doz)
    for k in ec.keys():
        print k, ec[k]

    
