/*	test_Conductor_Definition

PIRL CVS ID: test_Conductor_Definition.java,v 1.7 2012/04/16 06:04:12 castalia Exp

Copyright (C) 2008-2012	 Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/

import	PIRL.Conductor.Maestro.Conductor_Definition;

import	PIRL.Messenger.Message;
import	PIRL.Utilities.Checker;


public class test_Conductor_Definition
{
private static String 
	NL = System.getProperty ("line.separator") ;

private static Checker
	checker = new Checker ();


public static void main
	(
	String[] arguments
	)
{
System.out.println
	("*** test_Conductor_Definition" + NL
	+ Conductor_Definition.ID + NL);

if (arguments.length > 0 &&
	arguments[0].startsWith ("-v"))
	checker.Verbose = true;


int
	exit_status = 0;
try
{
Conductor_Definition
	definition,
	new_definition;
Message
	message;


//	Construction

message = new Message ();
message.Name ("definition");
definition = new Conductor_Definition (message);
String
	expected =
	"GROUP = definition" + NL +
    "	" + Conductor_Definition.PIPELINE_PARAMETER_NAME
		+ " = definition" + NL +
    "	" + Conductor_Definition.CONFIGURATION_PARAMETER_NAME
		+ " = Conductor.conf" + NL +
	"END_GROUP";
if (! checker.Check ("new Conductor_Definition (\"definition\")",
	expected, new Conductor_Definition ("definition").Description ()))
	Report (1);

message = new Message ();
message.Name ("definition");
definition = new Conductor_Definition (message);
if (! checker.Check ("new Conductor_Definition (new Message (\"definition\"))",
	expected, definition.Description ()))
	Report (1);

new_definition = new Conductor_Definition (definition);
if (! checker.Check ("Construct new_definition from definition",
	expected, new_definition.Description ()))
	Report (1);

if (! checker.Check ("definition.Matches (new_definition))",
	true, definition.Matches (new_definition)))
	{
	System.out.println
		("====> definition -" + NL
		+ definition + NL
		+"====> new_definition -" + NL
		+ new_definition);
	Report (1);
	}

expected =
	"GROUP = definition" + NL +
    "	" + Conductor_Definition.PIPELINE_PARAMETER_NAME
		+ " = pipeline" + NL +
    "	" + Conductor_Definition.CONFIGURATION_PARAMETER_NAME
		+ " = configuration" + NL +
	"	" + Conductor_Definition.SERVER_PARAMETER_NAME
		+ " = server" + NL +
	"	" + Conductor_Definition.CATALOG_PARAMETER_NAME
		+ " = catalog" + NL +
	"END_GROUP";
message = new Message ()
	.Set (Conductor_Definition.CATALOG_PARAMETER_NAME, "catalog")
	.Set (Conductor_Definition.SERVER_PARAMETER_NAME, "server")
	.Set (Conductor_Definition.CONFIGURATION_PARAMETER_NAME, "configuration")
	.Set (Conductor_Definition.PIPELINE_PARAMETER_NAME, "pipeline");
message.Name ("definition");
definition = new Conductor_Definition (message);
if (! checker.Check ("Parameter name ordering",
	expected, definition.Description ()))
	Report (1);

message
	.Set ("Extra", "extra")
	.Set ("Added", "added");
definition = new Conductor_Definition (message);
if (! checker.Check ("Irrelevant parameters removed.",
	expected, definition.Description ()))
	Report (1);

Exception
	expected_exception = new IllegalArgumentException (),
	obtained_exception = null;
try {new Conductor_Definition ((String)null);}
catch (Exception exception) {obtained_exception = exception;}
checker.Check
	("IllegalArgumentException - new Conductor_Definition ((String)null)",
	expected_exception,
	obtained_exception);

obtained_exception = null;
try {new Conductor_Definition (new Message ());}
catch (Exception exception) {obtained_exception = exception;}
checker.Check
	("IllegalArgumentException - new Conductor_Definition (new Message ())",
	expected_exception,
	obtained_exception);

message = new Message ()
	.Set (Conductor_Definition.PIPELINE_PARAMETER_NAME, "pipeline");
obtained_exception = null;
try {new Conductor_Definition (message);}
catch (Exception exception) {obtained_exception = exception;}
checker.Check
	("IllegalArgumentException - new Conductor_Definition (new Message ().Set (\""
		+ Conductor_Definition.PIPELINE_PARAMETER_NAME + "\", \"pipeline\"))",
	null,
	obtained_exception);


//	Matches

definition = new Conductor_Definition ("pipeline");
message = new Message ();
if (! checker.Check
	("new Conductor_Definition (\"pipeline\").Matches new Message () = false", 
	false, definition.Matches (message)))
	{
	System.out.println
		("====> message -" + NL
		+ definition + NL
		+"====> definition -" + NL
		+ definition);
	Report (1);
	}

message.Name ("pipeline");	
if (! checker.Check
	("new Conductor_Definition (\"pipeline\").Matches message.Name (\"pipeline\")", 
	true, definition.Matches (message)))
	{
	System.out.println
		("====> message -" + NL
		+ definition + NL
		+"====> definition -" + NL
		+ definition);
	Report (1);
	}

message = new Message ()
	.Set (Conductor_Definition.PIPELINE_PARAMETER_NAME, "pipeline");
if (! checker.Check ("definition.Matches with only \""
		+ Conductor_Definition.PIPELINE_PARAMETER_NAME + "\" parameter", 
	true, definition.Matches (message)))
	{
	System.out.println
		("====> message -" + NL
		+ definition + NL
		+"====> definition -" + NL
		+ definition);
	Report (1);
	}

message = new Message ()
	.Set (Conductor_Definition.CATALOG_PARAMETER_NAME, "catalog")
	.Set (Conductor_Definition.SERVER_PARAMETER_NAME, "server")
	.Set (Conductor_Definition.CONFIGURATION_PARAMETER_NAME, "configuration")
	.Set (Conductor_Definition.PIPELINE_PARAMETER_NAME, "pipeline");
message.Name ("pipeline");
definition = new Conductor_Definition (message);
if (! checker.Check ("definition.Matches Message with all parameters", 
	true, definition.Matches (message)))
	{
	System.out.println
		("====> message -" + NL
		+ definition + NL
		+"====> definition -" + NL
		+ definition);
	Report (1);
	}

message
	.Set ("Extra", "extra")
	.Set ("Added", "added");
if (! checker.Check ("definition.Matches Message with extra parameters", 
	true, definition.Matches (message)))
	{
	System.out.println
		("====> message -" + NL
		+ definition + NL
		+"====> definition -" + NL
		+ definition);
	Report (1);
	}

message.Remove (Conductor_Definition.CONFIGURATION_PARAMETER_NAME);
if (! checker.Check ("definition.Matches Message without \""
		+ Conductor_Definition.CONFIGURATION_PARAMETER_NAME
		+ "\" parameter = false", 
	false, definition.Matches (message)))
	{
	System.out.println
		("====> message -" + NL
		+ definition + NL
		+"====> definition -" + NL
		+ definition);
	Report (1);
	}

definition
	.Set (Conductor_Definition.CONFIGURATION_PARAMETER_NAME,
		Conductor_Definition.DEFAULT_CONFIGURATION_FILENAME);
if (! checker.Check
	("definition with default configuration Matches Message without \""
		+ Conductor_Definition.CONFIGURATION_PARAMETER_NAME
		+ "\" parameter = false", 
	true, definition.Matches (message)))
	{
	System.out.println
		("====> message -" + NL
		+ definition + NL
		+"====> definition -" + NL
		+ definition);
	Report (1);
	}


//	Start_Conductor_Message

message = new Message (definition);
message
	.Set (Conductor_Definition.ACTION_PARAMETER_NAME,
		Conductor_Definition.START_CONDUCTORS_ACTION, 0)
	.Name (definition.Name ());
checker.Check ("definition.Start_Conductor_Message (false, 0)",
	message.Description (),
	definition.Start_Conductor_Message (false, 0).Description ());
message
	.Set_Token (Conductor_Definition.WAIT_TO_START_PARAMETER_NAME);
message
	.Set (Conductor_Definition.COUNT_PARAMETER_NAME, 2);
checker.Check ("definition.Start_Conductor_Message (true, 2)",
	message.Description (),
	definition.Start_Conductor_Message (true, 2).Description ());
message
	.Remove (Conductor_Definition.WAIT_TO_START_PARAMETER_NAME);
checker.Check ("definition.Start_Conductor_Message (true, 2)",
	message.Description (),
	definition.Start_Conductor_Message (false, 2).Description ());

}
catch (Exception exception)
	{
	System.out.println (exception);
	exception.printStackTrace (System.out);
	exit_status = 1;
	}
Report (exit_status);
}


private static void Report
	(
	int		exit_status
	)
{
System.out.println ("\n" +
	"Checks: " + checker.Checks_Total + '\n' +
	"Passed: " + checker.Checks_Passed);

System.exit (exit_status);
}

}
