/* $NetBSD: casinf.c,v 1.1 2007/08/20 16:01:31 drochner Exp $ */

/*-
 * Copyright (c) 2007 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software written by Stephen L. Moshier.
 * It is redistributed by the NetBSD Foundation by permission of the author.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * imported and modified include for newlib 2010/10/03
 * Marco Atzeri <marco_atzeri@yahoo.it>
 */

#include <complex.h>
#include <math.h>

#ifdef __weak_alias
__weak_alias(casinf, _casinf)
#endif

    float complex casinf(float complex z)
{
    float complex w;
    float complex ca, ct, zz, z2;
    float         x, y;

    x = crealf(z);
    y = cimagf(z);

#if 0 /* MD: test is incorrect, casin(>1) is defined */
	if (y == 0.0f) {
		if (fabsf(x) > 1.0) {
			w = M_PI_2 + 0.0f * I;
#if 0
			mtherr ("casin", DOMAIN);
#endif
		} else {
			w = asinf(x) + 0.0f * I;
		}
		return w;
	}
#endif

    /* Power series expansion */
    /*
    b = cabsf(z);
    if( b < 0.125 )
    {
    z2.r = (x - y) * (x + y);
    z2.i = 2.0 * x * y;

    cn = 1.0;
    n = 1.0;
    ca.r = x;
    ca.i = y;
    sum.r = x;
    sum.i = y;
    do
            {
            ct.r = z2.r * ca.r  -  z2.i * ca.i;
            ct.i = z2.r * ca.i  +  z2.i * ca.r;
            ca.r = ct.r;
            ca.i = ct.i;

            cn *= n;
            n += 1.0;
            cn /= n;
            n += 1.0;
            b = cn/n;

            ct.r *= b;
            ct.i *= b;
            sum.r += ct.r;
            sum.i += ct.i;
            b = fabsf(ct.r) + fabsf(ct.i);
            }
    while( b > MACHEP );
    w->r = sum.r;
    w->i = sum.i;
    return;
    }
    */

    ca = x + y * I;
    ct = ca * I;
    /* sqrt( 1 - z*z) */
    /* cmul( &ca, &ca, &zz ) */
    /*x * x  -  y * y */
    zz = (x - y) * (x + y) + (2.0f * x * y) * I;

    zz = 1.0f - crealf(zz) - cimagf(zz) * I;
    z2 = csqrtf(zz);

    zz = ct + z2;
    zz = clogf(zz);
    /* multiply by 1/i = -i */
    w = zz * (-1.0f * I);
    return w;
}
