#!/usr/bin/env php
# autogenerated file; do not edit
language: c
sudo: required
dist: trusty

addons:
 apt:
  packages:
   - php5-cli
   - php-pear
   - libcurl4-openssl-dev
   - libidn11-dev
   - libidn2-0-dev
   - libicu-dev
   - libevent-dev

env:
<?php

$gen = include "./travis/pecl/gen-matrix.php";
$env = $gen([
	"PHP" => ["7.0", "7.1", "master"],
	"enable_debug",
	"enable_maintainer_zts",
	"enable_json",
	"enable_hash" => ["yes"],
	"enable_iconv" => ["yes"],
	"with_http_libicu_dir",
]);
foreach ($env as $e) {
	printf(" - %s\n", $e);
}

?>
# once with gcov
 - CFLAGS="-O0 -g --coverage" CXXFLAGS="-O0 -g --coverage" PHP=master enable_json=yes enable_hash=yes enable_iconv=yes 

before_script:
 - make -f travis/pecl/Makefile php
 - make -f travis/pecl/Makefile pecl PECL=raphf:raphf:2.0.0
 - make -f travis/pecl/Makefile pecl PECL=propro:propro:2.0.1
 - make -f travis/pecl/Makefile ext PECL=http

script:
 - make -f travis/pecl/Makefile test
 - make -f travis/pecl/Makefile cppcheck

after_failure:
 - test -e tests/helper/server.log && cat tests/helper/server.log
after_success:
 - test -n "$CFLAGS" && cd src/.libs && bash <(curl -s https://codecov.io/bash) -X xcode -X coveragepy

notifications:
 webhooks:
  urls:
   - https://webhooks.gitter.im/e/28d35158ac7e385bd14d
  on_success: change
  on_failure: always
  on_start: never
