%feature("docstring") PERSALYS::OptimizationAnalysis
"Perform the optimization analysis of a model.

Parameters
----------
name : str
    Name
physicalModel : :class:`~persalys.PhysicalModel`
    Physical model
solverName : str
    Optimization algorithm name (optional). Use :func:`GetSolverNames()` to list available names.

Examples
--------
>>> import openturns as ot
>>> import persalys

Create the model:

>>> R = persalys.Input('R', 0., ot.LogNormalMuSigma(300., 30., 0.).getDistribution(), 'Yield strength')
>>> F = persalys.Input('F', 0., ot.Normal(75000., 5000.), 'Traction load')
>>> G = persalys.Output('G', 'deviation')
>>> myPhysicalModel = persalys.SymbolicPhysicalModel('myPhysicalModel', [R, F], [G], ['R-F/(pi_*100.0)'])

Create the Model evaluation:

>>> analysis = persalys.OptimizationAnalysis('anAnalysis', myPhysicalModel, 'TNC')
>>> analysis.setInterestVariables(['G'])
>>> analysis.run()

Get the result:

>>> result = analysis.getResult()
>>> x = result.getOptimalPoint()
>>> y = result.getOptimalValue()"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::OptimizationAnalysis::getMaximumAbsoluteError
"Accessor to maximum allowed absolute error.

Returns
-------
maximumAbsoluteError : float
    Maximum allowed absolute error."

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::OptimizationAnalysis::getMaximumConstraintError
"Accessor to maximum allowed constraint error.

Returns
-------
maximumConstraintError : float
    Maximum allowed constraint error."

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::OptimizationAnalysis::getMaximumEvaluationNumber
"Accessor to maximum allowed number of evaluations.

Returns
-------
N : int
    Maximum allowed number of evaluations"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::OptimizationAnalysis::getMaximumRelativeError
"Accessor to maximum allowed relative error.

Returns
-------
maximumRelativeError : float
    Maximum allowed relative error."

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::OptimizationAnalysis::getMaximumResidualError
"Accessor to maximum allowed residual error.

Returns
-------
maximumResidualError : float
    Maximum allowed residual error."

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::OptimizationAnalysis::getStartingPoint
"Accessor to starting point.

Returns
-------
startingPoint : :class:`~openturns.Point`
    Starting point."

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::OptimizationAnalysis::setMaximumAbsoluteError
"Accessor to maximum allowed absolute error.

Parameters
----------
maximumAbsoluteError : float
    Maximum allowed absolute error."

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::OptimizationAnalysis::setMaximumConstraintError
"Accessor to maximum allowed constraint error.

Parameters
----------
maximumConstraintError : float
    Maximum allowed constraint error."

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::OptimizationAnalysis::setMaximumCallsNumber
"Accessor to maximum allowed number of calls.

Parameters
----------
N : int
    Maximum allowed number of calls."

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::OptimizationAnalysis::setMaximumRelativeError
"Accessor to maximum allowed relative error.

Parameters
----------
maximumRelativeError : float
    Maximum allowed relative error."

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::OptimizationAnalysis::setMaximumResidualError
"Accessor to maximum allowed residual error.

Parameters
----------
maximumResidualError : float
    Maximum allowed residual error."

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::OptimizationAnalysis::setStartingPoint
"Accessor to starting point.

Parameters
----------
startingPoint : sequence of float
    Starting point."

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::OptimizationAnalysis::getResult
"Accessor to optimization result.

Returns
-------
result : :class:`~openturns.OptimizationResult`
    Result class."

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::OptimizationAnalysis::getBounds
"Accessor to bounds.

Returns
-------
bounds : :class:`~openturns.Interval`
    Problem bounds."

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::OptimizationAnalysis::getMinimization
"Test whether this is a minimization or maximization problem.

Returns
-------
value : bool
    *True* if this is a minimization problem (default), *False* otherwise."

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::OptimizationAnalysis::setBounds
"Accessor to bounds.

Parameters
----------
bounds : :class:`~openturns.Interval`
    Problem bounds."

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::OptimizationAnalysis::setMinimization
"Tell whether this is a minimization or maximization problem.

Parameters
----------
minimization : bool
    *True* if this is a minimization problem, *False* otherwise."

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::OptimizationAnalysis::getSolverName
"Accessor to solver name

Returns
-------
solver : str
    Solver name"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::OptimizationAnalysis::setSolverName
"Accessor to solver name

Parameters
----------
solver : str
    Solver name"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::OptimizationAnalysis::getSolverName
"Accessor to solver name

Returns
-------
solver : str
    Solver name"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::OptimizationAnalysis::setSolverName
"Accessor to solver name

Parameters
----------
solver : str
    Solver name. Use :func:`GetSolverNames()` to list available names."

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::OptimizationAnalysis::GetSolverNames
"Accessor to the list of solver names.

Returns
-------
names : :class:`~openturns.Description`
    List of available solver names."

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::OptimizationAnalysis::getVariableInputs
"Accessor to variable input names

Returns
-------
inputs : :class:`~openturns.Description`
    Variable input names. It is set by default to the list of inputs of the model."

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::OptimizationAnalysis::setVariableInputs
"Accessor to variable input names

Parameters
----------
inputs : sequence of str
    Variable input names. It is set by default to the list of inputs of the model."

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::OptimizationAnalysis::getRawEquations
"Accessor to constraints equations

Returns
-------
equations : sequence of str
    Constraints equations"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::OptimizationAnalysis::addConstraint
"Adds a constraint to the analysis

Parameters
----------
constraint : str
    Constraint equation"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::OptimizationAnalysis::resetConstraints
"Clears the current analysis constraints"

// ---------------------------------------------------------------------
