#ifndef _iemarray_h
#define _iemarray_h

#include "iemlib.h"

static iemarray_t *iemarray_check(const void *x, const char*objectname,
  t_symbol *array_sym_name, t_int length)
{
  int n_points;
  t_garray *a;
  iemarray_t *vec;

  if(!(a = (t_garray *)pd_findbyclass(array_sym_name, garray_class)))
  {
    pd_error(x, "%s: no such array for %s", array_sym_name->s_name, objectname);
    return((iemarray_t *)0);
  }
  else if(!iemarray_getarray(a, &n_points, &vec))
  {
    pd_error(x, "%s: bad template for %s", array_sym_name->s_name, objectname);
    return((iemarray_t *)0);
  }
  else if(n_points < length)
  {
    pd_error(x, "%s: bad array-size for %s: %d", array_sym_name->s_name, objectname, n_points);
    return((iemarray_t *)0);
  }
  else
  {
    return(vec);
  }
}

#if ((defined PD_MAJOR_VERSION && defined PD_MINOR_VERSION) && (PD_MAJOR_VERSION > 0 || PD_MINOR_VERSION > 40))
# define iemarray_iadd(pointer, index, fvalue) (pointer[index].w_float += (fvalue))
# define iemarray_imul(pointer, index, fvalue) (pointer[index].w_float *= (fvalue))
#else
# define iemarray_iadd(pointer, index, fvalue) (pointer[index] += (fvalue))
# define iemarray_imul(pointer, index, fvalue) (pointer[index] *= (fvalue))
#endif

#endif /* _iemarray_h */
