/*****************************************************************************
*
* Copyright (c) 2000 - 2013, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <Point.h>
#include <DataNode.h>
#include <stdio.h>
#include <cstring>

//
// Enum conversion methods for Point::ValueType
//

static const char *ValueType_strings[] = {
"VT_Tuple", "VT_Min", "VT_Max", 
"VT_DomainZone", "VT_Zone", "VT_DomainNode", 
"VT_Node", "VT_Unknown"};

std::string
Point::ValueType_ToString(Point::ValueType t)
{
    int index = int(t);
    if(index < 0 || index >= 8) index = 0;
    return ValueType_strings[index];
}

std::string
Point::ValueType_ToString(int t)
{
    int index = (t < 0 || t >= 8) ? 0 : t;
    return ValueType_strings[index];
}

bool
Point::ValueType_FromString(const std::string &s, Point::ValueType &val)
{
    val = Point::VT_Tuple;
    for(int i = 0; i < 8; ++i)
    {
        if(s == ValueType_strings[i])
        {
            val = (ValueType)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: Point::Point
//
// Purpose: 
//   Init utility for the Point class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void Point::Init()
{

    Point::SelectAll();
}

// ****************************************************************************
// Method: Point::Point
//
// Purpose: 
//   Copy utility for the Point class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void Point::Copy(const Point &obj)
{
    value = obj.value;

    Point::SelectAll();
}

// Type map format string
const char *Point::TypeMapFormatString = POINT_TMFS;
const AttributeGroup::private_tmfs_t Point::TmfsStruct = {POINT_TMFS};


// ****************************************************************************
// Method: Point::Point
//
// Purpose: 
//   Default constructor for the Point class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

Point::Point() : 
    AttributeSubject(Point::TypeMapFormatString)
{
    Point::Init();
}

// ****************************************************************************
// Method: Point::Point
//
// Purpose: 
//   Constructor for the derived classes of Point class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

Point::Point(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    Point::Init();
}

// ****************************************************************************
// Method: Point::Point
//
// Purpose: 
//   Copy constructor for the Point class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

Point::Point(const Point &obj) : 
    AttributeSubject(Point::TypeMapFormatString)
{
    Point::Copy(obj);
}

// ****************************************************************************
// Method: Point::Point
//
// Purpose: 
//   Copy constructor for derived classes of the Point class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

Point::Point(const Point &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    Point::Copy(obj);
}

// ****************************************************************************
// Method: Point::~Point
//
// Purpose: 
//   Destructor for the Point class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

Point::~Point()
{
    // nothing here
}

// ****************************************************************************
// Method: Point::operator = 
//
// Purpose: 
//   Assignment operator for the Point class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

Point& 
Point::operator = (const Point &obj)
{
    if (this == &obj) return *this;

    Point::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: Point::operator == 
//
// Purpose: 
//   Comparison operator == for the Point class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
Point::operator == (const Point &obj) const
{
    // Create the return value
    return ((value == obj.value));
}

// ****************************************************************************
// Method: Point::operator != 
//
// Purpose: 
//   Comparison operator != for the Point class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
Point::operator != (const Point &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: Point::TypeName
//
// Purpose: 
//   Type name method for the Point class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
Point::TypeName() const
{
    return "Point";
}

// ****************************************************************************
// Method: Point::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the Point class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
Point::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const Point *tmp = (const Point *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: Point::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the Point class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
Point::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new Point(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: Point::NewInstance
//
// Purpose: 
//   NewInstance method for the Point class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
Point::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new Point(*this);
    else
        retval = new Point;

    return retval;
}

// ****************************************************************************
// Method: Point::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
Point::SelectAll()
{
    Select(ID_value, (void *)&value);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: Point::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
Point::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    Point defaultObject;
    bool addToParent = false;
    // Create a node for Point.
    DataNode *node = new DataNode("Point");

    if(completeSave || !FieldsEqual(ID_value, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("value", value));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: Point::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
Point::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("Point");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("value")) != 0)
        SetValue(node->AsString());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
Point::SetValue(const std::string &value_)
{
    value = value_;
    Select(ID_value, (void *)&value);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const std::string &
Point::GetValue() const
{
    return value;
}

std::string &
Point::GetValue()
{
    return value;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
Point::SelectValue()
{
    Select(ID_value, (void *)&value);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: Point::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
Point::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_value: return "value";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: Point::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
Point::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_value: return FieldType_string;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: Point::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
Point::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_value: return "string";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: Point::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
Point::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const Point &obj = *((const Point*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_value:
        {  // new scope
        retval = (value == obj.value);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
//  Method:  Point::Point
//
//  Purpose:
//    Constructor which takes a triple of values as input.
//
//  Arguments:
//    ox,oy,oz   the coordinate
//
//  Programmer:  Jeremy Meredith
//  Creation:    March 15, 2002
//
// ****************************************************************************

Point::Point(double ox, double oy, double oz) : AttributeSubject("s")
{
    char str[100];
    sprintf(str, "%g %g %g", ox, oy, oz);
    value = str;
}

// ****************************************************************************
//  Method:  Point::GetValueType
//
//  Purpose:
//    Get the type of function or tuple contained in the Point.
//
//  Programmer:  Jeremy Meredith
//  Creation:    March 15, 2002
//
// ****************************************************************************
Point::ValueType
Point::GetValueType() const
{
    int i;
    char s[1000];
    double d;

    if (GetTupleArgs(d,d,d))
        return VT_Tuple;
    if (GetMinArgs(s))
        return VT_Min;
    if (GetMaxArgs(s))
        return VT_Max;
    if (GetDomainZoneArgs(i,i))
        return VT_DomainZone;
    if (GetZoneArgs(i))
        return VT_Zone;
    if (GetDomainNodeArgs(i,i))
        return VT_DomainNode;
    if (GetNodeArgs(i))
        return VT_Node;

    return VT_Unknown;
}

// ****************************************************************************
//  Methods to parse tuples, functions, and arguments
// ****************************************************************************

bool
Point::GetTupleArgs(double &d1, double &d2, double &d3) const
{
    const char *str = value.c_str();
    return (sscanf(str, "%lg %lg %lg", &d1, &d2, &d3) == 3);
}

bool
Point::GetMinArgs(char *s) const
{
    const char *str = value.c_str();
    if (sscanf(str, "min( %[^) ] )", s) == 1)
        return true;
    else if (strcmp(str, "min()") == 0)
    {
        s[0] = '\0';
        return true;
    }
    else
        return false;
}

bool
Point::GetMaxArgs(char *s) const
{
    const char *str = value.c_str();
    if (sscanf(str, "max( %[^) ] )", s) == 1)
        return true;
    else if (strcmp(str, "min()") == 0)
    {
        s[0] = '\0';
        return true;
    }
    else
        return false;
}

bool
Point::GetDomainZoneArgs(int &d, int &z) const
{
    const char *str = value.c_str();
    return (sscanf(str, "zone( %d %d )", &d, &z) == 2);
}

bool
Point::GetZoneArgs(int &z) const
{
    const char *str = value.c_str();
    return (sscanf(str, "zone( %d )", &z) == 1);
}

bool
Point::GetDomainNodeArgs(int &d, int &n) const
{
    const char *str = value.c_str();
    return (sscanf(str, "node( %d %d )", &d, &n) == 2);
}

bool
Point::GetNodeArgs(int &n) const
{
    const char *str = value.c_str();
    return (sscanf(str, "node( %d )", &n) == 1);
}

