# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-12575 (cacti)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66584);
 script_cve_id("CVE-2009-4032");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"4.3");
 script_tag(name:"risk_factor", value:"Medium");
 script_name("Fedora Core 11 FEDORA-2009-12575 (cacti)");

 desc = "The remote host is missing an update to cacti
announced via advisory FEDORA-2009-12575.

Update Information:

This fix contains several official patches from cacti:
    Command Line Add Graphs Syntax
    SNMP Invalid Responses 
    Template Import/Export Duplication
    Cross-Site Scripting Fixes
http://www.cacti.net/download_patches.php

ChangeLog:

* Tue Dec  1 2009 Mike McGrath  - 0.8.7e-3
- Pulling in some official patches
- #541279
- #541962
* Sun Aug 16 2009 Mike McGrath  - 0.8.7e-1
- Upstream released new version
* Fri Jul 24 2009 Fedora Release Engineering  - 0.8.7d-4
- Rebuilt for https://fedoraproject.org/wiki/Fedora_12_Mass_Rebuild

References:

[ 1 ] Bug #541279 - CVE-2009-4032 Cacti: Multiple cross-site scripting flaws
https://bugzilla.redhat.com/show_bug.cgi?id=541279

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update cacti' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-12575

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 11 FEDORA-2009-12575 (cacti)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"cacti", rpm:"cacti~0.8.7e~3.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
