# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 216-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53455);
 script_cve_id("CVE-2002-1365");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 216-1 (fetchmail)";
 script_name(name);

 desc = "The remote host is missing an update to fetchmail
announced via advisory DSA 216-1.

Stefan Esser of e-matters discovered a buffer overflow in fetchmail,
an SSL enabled POP3, APOP and IMAP mail gatherer/forwarder.  When
fetchmail retrieves a mail all headers that contain addresses are
searched for local addresses.  If a hostname is missing, fetchmail
appends it but doesn't reserve enough space for it.  This heap
overflow can be used by remote attackers to crash it or to execute
arbitrary code with the privileges of the user running fetchmail.

For the current stable distribution (woody) this problem has been
fixed in version 5.9.11-6.2 of fetchmail and fetchmail-ssl.

For the old stable distribution (potato) this problem has been fixed
in version 5.3.3-4.3.

For the current unstable distribution (sid) this problem has been
fixed in version 6.2.0-1 of fetchmail and fetchmail-ssl.

We recommend that you upgrade your fetchmail packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20216-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 216-1 (fetchmail)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"fetchmailconf", ver:"5.3.3-4.3", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"fetchmail", ver:"5.3.3-4.3", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"fetchmail-common", ver:"5.9.11-6.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"fetchmailconf", ver:"5.9.11-6.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"fetchmail", ver:"5.9.11-6.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"fetchmail-ssl", ver:"5.9.11-6.2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
