# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1548-1 (xpdf)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60795);
 script_cve_id("CVE-2008-1693");
 script_version ("$");
 script_tag(name:"cvss_base", value:"6.8");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1548-1 (xpdf)";
 script_name(name);

 desc = "The remote host is missing an update to xpdf
announced via advisory DSA 1548-1.

Kees Cook discovered a vulnerability in xpdf, set set of tools for
display and conversion of Portable Document Format (PDF) files.  The
Common Vulnerabilities and Exposures project identifies the following
problem:

CVE-2008-1693

Xpdf's handling of embedded fonts lacks sufficient validation
and type checking.  If a maliciously-crafted PDF file is opened,
the vulnerability may allow the execution of arbitrary code with
the privileges of the user running xpdf.

For the stable distribution (etch), these problems have been fixed in
version 3.01-9.1+etch3.

For the unstable distribution (sid), these problems were fixed in
version 3.02-1.2.

We recommend that you upgrade your xpdf package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201548-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1548-1 (xpdf)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"xpdf", ver:"3.01-9.1+etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xpdf-common", ver:"3.01-9.1+etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xpdf-reader", ver:"3.01-9.1+etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xpdf-utils", ver:"3.01-9.1+etch4", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
