/*!
Copyright 2015 One.com

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
(function(root,factory){if(typeof exports==="object"){module.exports=factory(require("knockout"))}else if(typeof define==="function"&&define.amd){define(["knockout"],factory)}else{factory(root.ko)}})(this,function(ko){ko.transformations=ko.transformations||{fn:{}};function StateItem(inputItem,initialStateArrayIndex,initialOutputArrayIndex,mappingOptions,arrayOfState,outputObservableArray){this.inputItem=inputItem;this.stateArrayIndex=initialStateArrayIndex;this.mappingOptions=mappingOptions;this.arrayOfState=arrayOfState;this.outputObservableArray=outputObservableArray;this.outputArray=this.outputObservableArray.peek();this.isIncluded=null;this.suppressNotification=false;this.outputArrayIndex=ko.observable(initialOutputArrayIndex);this.disposeFuncFromMostRecentMapping=null;this.mappedValueComputed=ko.computed(this.mappingEvaluator,this);this.mappedValueComputed.subscribe(this.onMappingResultChanged,this);this.previousMappedValue=this.mappedValueComputed.peek()}StateItem.prototype.dispose=function(){this.mappedValueComputed.dispose();this.disposeResultFromMostRecentEvaluation()};StateItem.prototype.disposeResultFromMostRecentEvaluation=function(){if(this.disposeFuncFromMostRecentMapping){this.disposeFuncFromMostRecentMapping();this.disposeFuncFromMostRecentMapping=null}if(this.mappingOptions.disposeItem){var mappedItem=this.mappedValueComputed();this.mappingOptions.disposeItem(mappedItem)}};StateItem.prototype.mappingEvaluator=function(){if(this.isIncluded!==null){this.disposeResultFromMostRecentEvaluation()}var mappedValue;if(this.mappingOptions.mapping){mappedValue=this.mappingOptions.mapping(this.inputItem,this.outputArrayIndex)}else if(this.mappingOptions.mappingWithDisposeCallback){var mappedValueWithDisposeCallback=this.mappingOptions.mappingWithDisposeCallback(this.inputItem,this.outputArrayIndex);if(!("mappedValue"in mappedValueWithDisposeCallback)){throw new Error("Return value from mappingWithDisposeCallback should have a 'mappedItem' property.")}mappedValue=mappedValueWithDisposeCallback.mappedValue;this.disposeFuncFromMostRecentMapping=mappedValueWithDisposeCallback.dispose}else{throw new Error("No mapping callback given.")}if(this.isIncluded===null){this.isIncluded=mappedValue!==this.mappingOptions.exclusionMarker}return mappedValue};StateItem.prototype.updateInclusion=function(){var outputArrayIndex=this.outputArrayIndex.peek();var outputArray=this.outputArray;for(var iterationIndex=this.stateArrayIndex;iterationIndex<this.arrayOfState.length;iterationIndex+=1){var stateItem=this.arrayOfState[iterationIndex];stateItem.setOutputArrayIndexSilently(outputArrayIndex);var newValue=stateItem.mappingEvaluator();var newInclusionState=newValue!==this.mappingOptions.exclusionMarker;if(newInclusionState){outputArray[outputArrayIndex]=newValue;outputArrayIndex+=1}stateItem.previousMappedValue=newValue;stateItem.isIncluded=newInclusionState}if(outputArrayIndex<outputArray.length){outputArray.length=outputArrayIndex}};StateItem.prototype.onMappingResultChanged=function(newValue){if(newValue!==this.previousMappedValue){if(!this.suppressNotification){this.outputObservableArray.valueWillMutate()}var newInclusionState=newValue!==this.mappingOptions.exclusionMarker;if(this.isIncluded!==newInclusionState){this.updateInclusion()}else{if(newInclusionState){this.outputArray[this.outputArrayIndex.peek()]=newValue}this.previousMappedValue=newValue}if(!this.suppressNotification){this.outputObservableArray.valueHasMutated()}}};StateItem.prototype.setOutputArrayIndexSilently=function(newIndex){this.suppressNotification=true;this.outputArrayIndex(newIndex);this.suppressNotification=false};function getDiffEntryPostOperationIndex(diffEntry,editOffset){if(!diffEntry){return null}switch(diffEntry.status){case"added":return diffEntry.index;case"deleted":return diffEntry.index+editOffset;default:throw new Error("Unknown diff status: "+diffEntry.status)}}function insertOutputItem(diffEntry,movedStateItems,stateArrayIndex,outputArrayIndex,mappingOptions,arrayOfState,outputObservableArray,outputArray){var isMoved=typeof diffEntry.moved==="number",stateItem=isMoved?movedStateItems[diffEntry.moved]:new StateItem(diffEntry.value,stateArrayIndex,outputArrayIndex,mappingOptions,arrayOfState,outputObservableArray);arrayOfState.splice(stateArrayIndex,0,stateItem);if(stateItem.isIncluded){outputArray.splice(outputArrayIndex,0,stateItem.mappedValueComputed.peek())}if(isMoved){stateItem.stateArrayIndex=stateArrayIndex;stateItem.setOutputArrayIndexSilently(outputArrayIndex)}return stateItem}function deleteOutputItem(diffEntry,arrayOfState,stateArrayIndex,outputArrayIndex,outputArray){var stateItem=arrayOfState.splice(stateArrayIndex,1)[0];if(stateItem.isIncluded){outputArray.splice(outputArrayIndex,1)}if(typeof diffEntry.moved!=="number"){stateItem.dispose()}}function updateRetainedOutputItem(stateItem,stateArrayIndex,outputArrayIndex){stateItem.stateArrayIndex=stateArrayIndex;stateItem.setOutputArrayIndexSilently(outputArrayIndex);return outputArrayIndex+(stateItem.isIncluded?1:0)}function makeLookupOfMovedStateItems(diff,arrayOfState){var movedStateItems={};for(var diffIndex=0;diffIndex<diff.length;diffIndex+=1){var diffEntry=diff[diffIndex];if(diffEntry.status==="added"&&typeof diffEntry.moved==="number"){movedStateItems[diffEntry.moved]=arrayOfState[diffEntry.moved]}}return movedStateItems}function getFirstModifiedOutputIndex(firstDiffEntry,arrayOfState,outputArray){if(!outputArray.length||!arrayOfState[firstDiffEntry.index]){return outputArray.length}else{return arrayOfState[firstDiffEntry.index].outputArrayIndex.peek()}}function respondToArrayStructuralChanges(inputObservableArray,arrayOfState,outputArray,outputObservableArray,mappingOptions){return inputObservableArray.subscribe(function(diff){if(!diff.length){return}if(arrayOfState.length===0){var newOutputItems=[];ko.utils.arrayForEach(diff,function(diffEntry,i){var inputItem=diffEntry.value;var stateItem=new StateItem(inputItem,i,newOutputItems.length,mappingOptions,arrayOfState,outputObservableArray);var mappedValue=stateItem.mappedValueComputed.peek();arrayOfState.push(stateItem);if(stateItem.isIncluded){newOutputItems.push(mappedValue)}});outputObservableArray.push.apply(outputObservableArray,newOutputItems);return}outputObservableArray.valueWillMutate();var movedStateItems=makeLookupOfMovedStateItems(diff,arrayOfState),diffIndex=0,diffEntry=diff[0],editOffset=0,outputArrayIndex=diffEntry&&getFirstModifiedOutputIndex(diffEntry,arrayOfState,outputArray);for(var stateArrayIndex=diffEntry.index;diffEntry||stateArrayIndex<arrayOfState.length;stateArrayIndex+=1){if(getDiffEntryPostOperationIndex(diffEntry,editOffset)===stateArrayIndex){switch(diffEntry.status){case"added":var stateItem=insertOutputItem(diffEntry,movedStateItems,stateArrayIndex,outputArrayIndex,mappingOptions,arrayOfState,outputObservableArray,outputArray);if(stateItem.isIncluded){outputArrayIndex+=1}editOffset+=1;break;case"deleted":deleteOutputItem(diffEntry,arrayOfState,stateArrayIndex,outputArrayIndex,outputArray);editOffset-=1;stateArrayIndex-=1;break;default:throw new Error("Unknown diff status: "+diffEntry.status)}diffIndex+=1;diffEntry=diff[diffIndex]}else if(stateArrayIndex<arrayOfState.length){outputArrayIndex=updateRetainedOutputItem(arrayOfState[stateArrayIndex],stateArrayIndex,outputArrayIndex)}}outputObservableArray.valueHasMutated()},null,"arrayChange")}ko.observableArray.fn.map=ko.transformations.fn.map=function map(mappingOptions){var that=this,arrayOfState=[],outputArray=[],outputObservableArray=ko.observableArray(outputArray),originalInputArrayContents=that.peek();if(typeof mappingOptions==="function"){mappingOptions={mapping:mappingOptions}}if(!mappingOptions.exclusionMarker){mappingOptions.exclusionMarker={}}if(mappingOptions.mappingWithDisposeCallback){if(mappingOptions.mapping||mappingOptions.disposeItem){throw new Error("'mappingWithDisposeCallback' cannot be used in conjunction with 'mapping' or 'disposeItem'.")}}else if(!mappingOptions.mapping){throw new Error("Specify either 'mapping' or 'mappingWithDisposeCallback'.")}for(var i=0;i<originalInputArrayContents.length;i+=1){var inputItem=originalInputArrayContents[i],stateItem=new StateItem(inputItem,i,outputArray.length,mappingOptions,arrayOfState,outputObservableArray),mappedValue=stateItem.mappedValueComputed.peek();arrayOfState.push(stateItem);if(stateItem.isIncluded){outputArray.push(mappedValue)}}var inputArraySubscription=respondToArrayStructuralChanges(that,arrayOfState,outputArray,outputObservableArray,mappingOptions);var outputComputed=ko.computed(outputObservableArray);if("throttle"in mappingOptions){outputComputed=outputComputed.extend({throttle:mappingOptions.throttle})}var returnValue=outputComputed.extend({trackArrayChanges:true}),originalDispose=returnValue.dispose;returnValue.dispose=function(){inputArraySubscription.dispose();ko.utils.arrayForEach(arrayOfState,function(stateItem){stateItem.dispose()});originalDispose.call(this,arguments)};ko.utils.extend(returnValue,ko.transformations.fn);return returnValue};return ko.transformations.fn.map});(function(root,factory){if(typeof exports==="object"){module.exports=factory(require("knockout"),require("./map"))}else if(typeof define==="function"&&define.amd){define(["knockout","./map"],factory)}else{var ko=root.ko;factory(ko,ko.transformations.fn.map)}})(this,function(ko,map){ko.observable.fn.filter=ko.transformations.fn.filter=function filter(mappingOptions){if(typeof mappingOptions==="function"){mappingOptions={mapping:mappingOptions}}var predicate=mappingOptions.mapping;var exclusionMarker={};mappingOptions.mapping=function(item){return predicate(item)?item:exclusionMarker};mappingOptions.exclusionMarker=exclusionMarker;return map.call(this,mappingOptions)};return ko.transformations.fn.filter});(function(root,factory){if(typeof exports==="object"){module.exports=factory(require("knockout"))}else if(typeof define==="function"&&define.amd){define(["knockout"],factory)}else{factory(root.ko)}})(this,function(ko){ko.transformations=ko.transformations||{fn:{}};function sortingKeysEquals(aSortKeys,bSortKeys){var Descending=SortByTransformation.Descending;if(!Array.isArray(aSortKeys)){aSortKeys=[aSortKeys];bSortKeys=[bSortKeys]}var aSortKey,bSortKey;for(var i=0;i<aSortKeys.length;i+=1){aSortKey=aSortKeys[i];bSortKey=bSortKeys[i];if(aSortKey instanceof Descending){if(bSortKey instanceof Descending){aSortKey=aSortKey.value;bSortKey=bSortKey.value}else{return false}}if(aSortKey!==bSortKey){return false}}return true}function compareSortingKeys(aSortKeys,bSortKeys,comparator){var Descending=SortByTransformation.Descending;if(!Array.isArray(aSortKeys)){aSortKeys=[aSortKeys];bSortKeys=[bSortKeys]}var aSortKey,bSortKey,comparison;for(var i=0;i<aSortKeys.length;i+=1){aSortKey=aSortKeys[i];bSortKey=bSortKeys[i];if(aSortKey instanceof Descending){comparison=comparator(bSortKey.value,aSortKey.value)}else{comparison=comparator(aSortKey,bSortKey)}if(comparison!==0){return comparison}}return 0}function mappingToComparefn(mapping,comparator){var Descending=SortByTransformation.Descending;return function(a,b){var aSortKeys=mapping(a,Descending.create);var bSortKeys=mapping(b,Descending.create);return compareSortingKeys(aSortKeys,bSortKeys,comparator)}}function binarySearch(items,item,comparefn){var left=-1,right=items.length,mid;while(right-left>1){mid=left+right>>>1;var c=comparefn(items[mid],item);if(c<0){left=mid}else{right=mid;if(!c){break}}}return right===items.length||comparefn(items[right],item)?-right-1:right}function findInsertionIndex(items,newItem,comparefn){var left=-1,right=items.length,mid;while(right-left>1){mid=left+right>>>1;if(comparefn(items[mid],newItem)<0){left=mid}else{right=mid}}return right}function binaryIndexOf(items,item,comparefn){var index=binarySearch(items,item,comparefn);if(index<0||items.length<=index||comparefn(items[index],item)!==0){return-1}else{var startIndex=index;while(index-1>=0&&comparefn(items[index-1],item)===0){index-=1}while(index<=startIndex){if(items[index]===item){return index}index+=1}while(index<items.length){if(comparefn(items[index],item)!==0){return-1}if(items[index]===item){return index}index+=1}return-1}}function SortedStateItem(transformation,inputItem){this.transformation=transformation;this.inputItem=inputItem;this.mappedValueComputed=ko.computed(this.mappingEvaluator,this);this.mappedValueComputed.subscribe(this.onMappingResultChanged,this);this.previousMappedValue=this.mappedValueComputed.peek()}SortedStateItem.prototype.dispose=function(){var mappedItem=this.mappedValueComputed();this.mappedValueComputed.dispose();if(this.transformation.options.disposeItem){this.transformation.options.disposeItem(mappedItem)}};SortedStateItem.prototype.mappingEvaluator=function(){return this.transformation.mapping(this.inputItem,SortByTransformation.Descending.create)};SortedStateItem.prototype.onMappingResultChanged=function(newValue){if(!sortingKeysEquals(newValue,this.previousMappedValue)){var transformation=this.transformation;var outputObservable=transformation.outputObservable;var outputArray=outputObservable.peek();var stateItems=transformation.stateItems;var oldIndex=binaryIndexOf(stateItems,this,mappingToComparefn(function(stateItem){return stateItem.previousMappedValue},transformation.comparator));if(stateItems[oldIndex]===this){outputObservable.valueWillMutate();outputArray.splice(oldIndex,1);stateItems.splice(oldIndex,1);var index=findInsertionIndex(outputArray,this.inputItem,transformation.comparefn);outputArray.splice(index,0,this.inputItem);stateItems.splice(index,0,this);this.previousMappedValue=newValue;outputObservable.valueHasMutated()}else{ko.utils.arrayForEach(stateItems,function(stateItem){stateItem.previousMappedValue=stateItem.mappingEvaluator()});stateItems.sort(mappingToComparefn(function(stateItem){return stateItem.previousMappedValue},transformation.comparator));outputArray=[];ko.utils.arrayForEach(stateItems,function(stateItem){outputArray.push(stateItem.inputItem)});outputObservable(outputArray)}}};function SortByTransformation(inputObservableArray,options){var that=this;this.options=options;this.mapping=options.mapping;if(options.comparator){this.comparator=options.comparator}else{this.comparator=function(a,b){if(a>b){return 1}else if(b>a){return-1}else{return 0}}}this.comparefn=mappingToComparefn(this.mapping,this.comparator);this.stateItems=ko.utils.arrayMap(inputObservableArray.peek(),function(inputItem){return new SortedStateItem(that,inputItem)});this.stateItems.sort(function(a,b){return compareSortingKeys(a.mappedValueComputed(),b.mappedValueComputed(),that.comparator)});this.outputObservable=ko.observable(ko.utils.arrayMap(this.stateItems,function(stateItem){return stateItem.inputItem}));var inputArraySubscription=inputObservableArray.subscribe(this.onStructuralChange,this,"arrayChange");var outputComputed=ko.computed(this.outputObservable);if("throttle"in options){outputComputed=outputComputed.extend({throttle:options.throttle})}this.output=outputComputed.extend({trackArrayChanges:true});var originalDispose=this.output.dispose;this.output.dispose=function(){inputArraySubscription.dispose();ko.utils.arrayForEach(that.stateItems,function(stateItem){stateItem.dispose()});originalDispose.call(this,arguments)};ko.utils.extend(this.output,ko.transformations.fn)}SortByTransformation.Descending=function Descending(value){this.value=value};SortByTransformation.Descending.create=function(value){return new SortByTransformation.Descending(value)};SortByTransformation.prototype.onStructuralChange=function(diff){if(!diff.length){return}this.outputObservable.valueWillMutate();var that=this;var addQueue=[];var deleteQueue=[];ko.utils.arrayForEach(diff,function(diffEntry){if(typeof diffEntry.moved!=="number"){switch(diffEntry.status){case"added":addQueue.push(diffEntry);break;case"deleted":deleteQueue.push(diffEntry);break}}});var outputArray=this.outputObservable.peek();ko.utils.arrayForEach(deleteQueue,function(diffEntry){var index=binaryIndexOf(outputArray,diffEntry.value,that.comparefn);if(index!==-1){outputArray.splice(index,1);that.stateItems[index].dispose();that.stateItems.splice(index,1)}});if(deleteQueue.length===0&&this.stateItems.length===0){this.stateItems=ko.utils.arrayMap(addQueue,function(diffEntry){return new SortedStateItem(that,diffEntry.value)});this.stateItems.sort(function(a,b){return compareSortingKeys(a.mappedValueComputed(),b.mappedValueComputed(),that.comparator)});ko.utils.arrayForEach(this.stateItems,function(stateItem){outputArray.push(stateItem.inputItem)})}else{ko.utils.arrayForEach(addQueue,function(diffEntry){var index=findInsertionIndex(outputArray,diffEntry.value,that.comparefn);var stateItem=new SortedStateItem(that,diffEntry.value);outputArray.splice(index,0,stateItem.inputItem);that.stateItems.splice(index,0,stateItem)})}this.outputObservable.valueHasMutated()};ko.observableArray.fn.sortBy=ko.transformations.fn.sortBy=function sortBy(options){if(typeof options==="function"){options={mapping:options}}var transformation=new SortByTransformation(this,options);return transformation.output};return ko.transformations.fn.sortBy});(function(root,factory){if(typeof exports==="object"){module.exports=factory(require("knockout"))}else if(typeof define==="function"&&define.amd){define(["knockout"],factory)}else{factory(root.ko)}})(this,function(ko){ko.transformations=ko.transformations||{fn:{}};function IndexByTransformation(inputObservableArray,options){var that=this;this.options=options;this.outputObservable=ko.observable({});this.stateItems={};this.mapping=function(item){return[].concat(options.mapping(item))};var inputArray=inputObservableArray.peek();for(var i=0;i<inputArray.length;i+=1){this.addToIndex(inputArray[i],i)}var inputArraySubscription=inputObservableArray.subscribe(this.onStructuralChange,this,"arrayChange");var outputComputed=ko.computed(this.outputObservable);if("throttle"in options){outputComputed=outputComputed.extend({throttle:options.throttle})}this.output=outputComputed;var originalDispose=this.output.dispose;this.output.dispose=function(){inputArraySubscription.dispose();for(var prop in that.stateItems){if(that.stateItems.hasOwnProperty(prop)){that.stateItems[prop].dispose()}}originalDispose.call(this,arguments)};ko.utils.extend(this.output,ko.transformations.fn)}IndexByTransformation.prototype.arraysEqual=function(a,b){if(a===b){return true}if(typeof a==="undefined"||typeof b==="undefined"){return false}if(a.length!==b.length){return false}for(var i=0;i<a.length;i+=1){if(ko.observable.fn.equalityComparer&&ko.isObservable(a[i])&&!ko.observable.fn.equalityComparer(a[i],b[i])||a[i]!==b[i]){return false}}return true};IndexByTransformation.prototype.appendToEntry=function(obj,key,item){var entry=obj[key];if(!entry){entry=obj[key]=[]}entry.push(item)};IndexByTransformation.prototype.removeFromEntry=function(obj,key,item){var entry=obj[key];if(entry){var index=entry.indexOf(item);if(index!==-1){if(entry.length===1){delete obj[key]}else{entry.splice(index,1)}}}};IndexByTransformation.prototype.insertByKeyAndItem=function(indexMapping,key,item){this.appendToEntry(indexMapping,key,item)};IndexByTransformation.prototype.removeByKeyAndItem=function(indexMapping,key,item){this.removeFromEntry(indexMapping,key,item)};IndexByTransformation.prototype.addStateItemToIndex=function(stateItem){var key=this.mapping(stateItem.inputItem)[0];this.appendToEntry(this.stateItems,key,stateItem)};IndexByTransformation.prototype.findStateItem=function(inputItem){var key=this.mapping(inputItem)[0];var entry=this.stateItems[key];if(!entry){return null}var result=ko.utils.arrayFilter(entry,function(stateItem){return stateItem.inputItem===inputItem});return result[0]||null};IndexByTransformation.prototype.removeStateItem=function(stateItem){var key=stateItem.mappedValueComputed()[0];this.removeFromEntry(this.stateItems,key,stateItem);stateItem.dispose()};IndexByTransformation.prototype.addToIndex=function(inputItem){var that=this;var keys=this.mapping(inputItem);var output=this.outputObservable.peek();ko.utils.arrayForEach(keys,function(key){that.insertByKeyAndItem(output,key,inputItem)});var stateItem=new IndexedStateItem(this,inputItem);this.addStateItemToIndex(stateItem)};IndexByTransformation.prototype.removeItem=function(inputItem){var that=this;var stateItem=this.findStateItem(inputItem);if(stateItem){var keys=stateItem.mappedValueComputed();var output=this.outputObservable.peek();ko.utils.arrayForEach(keys,function(key){that.removeByKeyAndItem(output,key,inputItem)});this.removeStateItem(stateItem)}};IndexByTransformation.prototype.onStructuralChange=function(diff){var that=this;if(!diff.length){return}var addQueue=[];var deleteQueue=[];ko.utils.arrayForEach(diff,function(diffEntry){if(typeof diffEntry.moved!=="number"){switch(diffEntry.status){case"added":addQueue.push(diffEntry);break;case"deleted":deleteQueue.push(diffEntry);break}}});ko.utils.arrayForEach(deleteQueue,function(diffEntry){that.removeItem(diffEntry.value,diffEntry.index)});ko.utils.arrayForEach(addQueue,function(diffEntry){that.addToIndex(diffEntry.value,diffEntry.index)});this.outputObservable.valueHasMutated()};function IndexedStateItem(transformation,inputItem){this.transformation=transformation;this.inputItem=inputItem;this.mappedValueComputed=ko.computed(this.mappingEvaluator,this);this.mappedValueComputed.subscribe(this.onMappingResultChanged,this);this.previousMappedValue=this.mappedValueComputed.peek()}IndexedStateItem.prototype.dispose=function(){var mappedItem=this.mappedValueComputed();this.mappedValueComputed.dispose();if(this.transformation.options.disposeItem){this.transformation.options.disposeItem(mappedItem)}};IndexedStateItem.prototype.mappingEvaluator=function(){return this.transformation.mapping(this.inputItem)};function toArray(value){return Array.isArray(value)?value:[value]}IndexedStateItem.prototype.onMappingResultChanged=function(newValue){var transformation=this.transformation;if(!transformation.arraysEqual(this.newValue,this.previousMappedValue)){var outputObservable=transformation.outputObservable;var output=outputObservable.peek();outputObservable.valueWillMutate();var that=this;ko.utils.arrayForEach(toArray(this.previousMappedValue),function(key){transformation.removeByKeyAndItem(output,key,that.inputItem);transformation.removeByKeyAndItem(transformation.stateItems,key,that)});ko.utils.arrayForEach(toArray(newValue),function(key){transformation.insertByKeyAndItem(output,key,that.inputItem)});transformation.addStateItemToIndex(this);this.previousMappedValue=newValue;outputObservable.valueHasMutated()}};function UniqueIndexByTransformation(inputObservableArray,options){IndexByTransformation.call(this,inputObservableArray,options)}ko.utils.extend(UniqueIndexByTransformation.prototype,IndexByTransformation.prototype);UniqueIndexByTransformation.prototype.insertByKeyAndItem=function(indexMapping,key,item){if(key in indexMapping){throw new Error("Unique indexes requires items must map to different keys; duplicate key: "+key)}indexMapping[key]=item};UniqueIndexByTransformation.prototype.removeByKeyAndItem=function(indexMapping,key){delete indexMapping[key]};UniqueIndexByTransformation.prototype.addStateItemToIndex=function(stateItem){var key=stateItem.mappedValueComputed()[0];this.stateItems[key]=stateItem};UniqueIndexByTransformation.prototype.findStateItem=function(inputItem){var key=this.mapping(inputItem)[0];return this.stateItems[key]||null};UniqueIndexByTransformation.prototype.removeStateItem=function(stateItem){var key=stateItem.mappedValueComputed()[0];if(this.stateItems[key]===stateItem){delete this.stateItems[key]}stateItem.dispose()};UniqueIndexByTransformation.prototype.addToIndex=function(inputItem){var that=this;var keys=this.mapping(inputItem);var output=this.outputObservable.peek();ko.utils.arrayForEach(keys,function(key){that.insertByKeyAndItem(output,key,inputItem)});var stateItem=new UniqueIndexedStateItem(this,inputItem);this.addStateItemToIndex(stateItem)};UniqueIndexByTransformation.prototype.removeItem=function(inputItem){var that=this;var stateItem=this.findStateItem(inputItem);if(stateItem){var keys=stateItem.mappedValueComputed();var output=this.outputObservable.peek();ko.utils.arrayForEach(keys,function(key){that.removeByKeyAndItem(output,key,inputItem)});this.removeStateItem(stateItem)}};function UniqueIndexedStateItem(transformation,inputItem){IndexedStateItem.call(this,transformation,inputItem)}ko.utils.extend(UniqueIndexedStateItem.prototype,IndexedStateItem.prototype);ko.observableArray.fn.indexBy=ko.transformations.fn.indexBy=function indexBy(options){if(typeof options==="function"){options={mapping:options,unique:false}}var transformation=options.unique?new UniqueIndexByTransformation(this,options):new IndexByTransformation(this,options);return transformation.output};ko.observableArray.fn.uniqueIndexBy=ko.transformations.fn.uniqueIndexBy=function uniqueIndexBy(options){if(typeof options==="function"){options={mapping:options}}options.unique=true;var transformation=new UniqueIndexByTransformation(this,options);return transformation.output};return ko.transformations.fn.indexBy});