/** @file gen_version.c Generates a "version.h" file from an argument.*/

#include <stdio.h>

int main(int argc, char* argv[])
{
    if (argc!=2) {
        fprintf(stderr, "gen_version_h error: I need one argument.\n");
        return 1;
    }
    unsigned a, b=0, c=0;
    const char *arg = argv[1];
    if (*arg == 'v') arg++;
    int num = sscanf(arg, "%u.%u.%u", &a, &b, &c);
    if (3!=num && 2!=num) {
        fprintf(stderr, "gen_version_h error: I need the argument as [v]<num>.<num>[.<num>]\n");
        return 1;
    }
    printf("/** @file version.h Containing version macros.\n");
    printf(" * @ingroup libmscgen_files */\n");
    printf("\n");
    printf("#ifndef VERSION_H\n");
    printf("#define VERSION_H\n");
    printf("/** The major version of libmscgen.*/\n");
    printf("#define LIBMSCGEN_MAJOR %u\n", a);
    printf("/** The minor version of libmscgen.*/\n");
    printf("#define LIBMSCGEN_MINOR %u\n", b);
    printf("/** The micro version of libmscgen.*/\n");
    printf("#define LIBMSCGEN_SUPERMINOR %u\n", c);
    printf("\n");
    printf("#endif //VERSION_H\n");
    return 0;
}


